package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderItemQryBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspDetailBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemFormatBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetCmpOrderDetailServiceRspItemFormatChildBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCmpOrderDetailBySaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCmpOrderDetailServiceBySaleOrderRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/*
 * @Author lsl
 * @Description //TODO 查询订单比选单详情
 * @Date 14:21 2023/8/17
 * @Param
 * @return
 */
@HTServiceImpl
public class UocQryCmpOrderDetailBySaleOrderServiceImpl implements UocGetCmpOrderDetailBySaleOrderService {

    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    
    @Autowired
    private IUocSaleOrderModel uocSaleOrderModel;

    @Override
    public UocGetCmpOrderDetailServiceBySaleOrderRspBo qryCmpOrderDetail(UocGetCmpOrderDetailBySaleOrderServiceReqBo reqBo) {
        validateArg(reqBo);
        UocGetCmpOrderDetailServiceBySaleOrderRspBo rspBo = UocRu.success(UocGetCmpOrderDetailServiceBySaleOrderRspBo.class);
        List<UocGetCmpOrderDetailServiceRspDetailBo> cmpOrderDetailinfoList = new ArrayList<>();
        
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo =  uocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        
        //过滤出必选单号不为空的销售订单明细行,如果全部为空，则直接退出
        List<UocSaleOrderItem> filterList = saleOrderItems.stream().filter(e ->ObjectUtil.isNotEmpty(e.getCmpOrderNo())).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(filterList)){
            return rspBo;
        }
        List<String> cmpOrderNoList = filterList.stream().map(UocSaleOrderItem::getCmpOrderNo).collect(Collectors.toList());
        
        for (String cmpOrderNo: cmpOrderNoList){
            UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
            uocCmpOrderQryBo.setCmpOrderNo(cmpOrderNo);
            UocCmpOrderQryBo cmpOrderDetail = uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
            if (ObjectUtil.isNotEmpty(cmpOrderDetail)) {
                UocGetCmpOrderDetailServiceRspDetailBo cmpOrderBo = UocRu.js(cmpOrderDetail, UocGetCmpOrderDetailServiceRspDetailBo.class);
                List<UocCmpOrderItemQryBo> uocCmpOrderItemList = cmpOrderDetail.getUocCmpOrderItemList();
                for(UocCmpOrderItemQryBo each: uocCmpOrderItemList){
                    each.setVendorId(each.getGoodsSupplierId());
                }
                if (CollectionUtil.isNotEmpty(uocCmpOrderItemList)) {
                    cmpOrderBo.setUocCmpOrderItemList(UocRu.jsl(uocCmpOrderItemList, UocGetCmpOrderDetailServiceRspItemBo.class));
                    //商品主图
                    cmpOrderBo.setSkuMainPicUrl(uocCmpOrderItemList.get(0).getImgUrl());
                    //前端格式商品明细
                    cmpOrderBo.setUocCmpOrderItemFormatList(new ArrayList<>());
                    ConcurrentMap<String, List<UocCmpOrderItemQryBo>> cmpOrderItemsMap = uocCmpOrderItemList.stream().collect(Collectors.groupingByConcurrent(UocCmpOrderItemQryBo::getSpuId));
                    Iterator<String> iterator = cmpOrderItemsMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = iterator.next();
                        UocGetCmpOrderDetailServiceRspItemFormatBo formatBo = new UocGetCmpOrderDetailServiceRspItemFormatBo();
                        formatBo.setCmpOrderNo(cmpOrderBo.getCmpOrderNo());
                        formatBo.setImgUrl(cmpOrderItemsMap.get(key).get(0).getImgUrl());
                        formatBo.setRemark(cmpOrderItemsMap.get(key).get(0).getRemark());
                        formatBo.setUocCmpItemFormatChildList(UocRu.jsl(cmpOrderItemsMap.get(key), UocGetCmpOrderDetailServiceRspItemFormatChildBo.class));
                        cmpOrderBo.getUocCmpOrderItemFormatList().add(formatBo);
                    }
                }
                cmpOrderDetailinfoList.add(cmpOrderBo);
            }
        }
        rspBo.setCmpOrderDetailinfoList(cmpOrderDetailinfoList);

        return rspBo;
    }

    private void validateArg(UocGetCmpOrderDetailBySaleOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocGetCmpOrderDetailBySaleOrderServiceReqBo]不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[销售单id]不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[订单id]不能为空");
        }
    }
}
