package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendEcPlatOrderInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendEcPlatOrderInfoRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSendEcPlatOrderBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @description 电子商务平台订单信息推送查询接口
 * @author Luokan
 * @date 2024/07/09
 **/
@HTServiceImpl
public class UocQrySendEcPlatOrderInfoServiceImpl implements UocQrySendEcPlatOrderInfoService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQrySendEcPlatOrderInfoRspBO qrySendEcPlatOrderInfo(UocQrySendEcPlatOrderInfoReqBO reqBO) {
        UocQrySendEcPlatOrderInfoRspBO rspBO = UocRu.success(UocQrySendEcPlatOrderInfoRspBO.class);
        //查询销售单，查询销售明细,三方信息
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        UocSaleStakeholderQryBo uocSaleStakeholderQryBo = new UocSaleStakeholderQryBo();
        uocSaleStakeholderQryBo.setOrderId(result.getOrderId());
        uocSaleStakeholderQryBo.setStakeholderId(result.getStakeholderId());
        UocSaleStakeholder stock = this.iUocSaleOrderModel.getSaleOrderStakeholder(uocSaleStakeholderQryBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            List<UocSendEcPlatOrderBO> sendEcPlatOrderBOList = new ArrayList<>();
            for (UocSaleOrderItem bo : saleOrderItemList) {
                UocSendEcPlatOrderBO uocSendEcPlatOrderBO = new UocSendEcPlatOrderBO();
                //是	京能e购订单Id
                uocSendEcPlatOrderBO.setSaleOrderId(bo.getSaleOrderId());
                //是	京能e购订单编号
                uocSendEcPlatOrderBO.setSaleOrderNo(result.getSaleOrderNo());
                //是	京能e购订单明细编号
                uocSendEcPlatOrderBO.setSaleOrderItemId(bo.getSaleOrderItemId());
                //否	sap订单编号	SAP计划的情况必须
                uocSendEcPlatOrderBO.setSapOrderNo(bo.getSapOrderNo());
                //否	sap订单行编号	SAP计划的情况必须
                uocSendEcPlatOrderBO.setSapOrderItemNo(bo.getSapOrderItemNo());
                //是	商品编码	skuCode
                uocSendEcPlatOrderBO.setSkuCode(bo.getSkuCode());
                //是	商品名称	skuName
                uocSendEcPlatOrderBO.setSkuName(bo.getSkuName());
                //是	商品单价（元）	salePrice
                uocSendEcPlatOrderBO.setSalePrice(bo.getSalePrice());
                //是	下单数量	purchaseCount
                uocSendEcPlatOrderBO.setPurchaseCount(bo.getPurchaseCount());
                //是	申购人	下单人名称
                uocSendEcPlatOrderBO.setCreateOperName(result.getCreateOperName());
                //是	申购人账号	登录名
                //是	供应商名称
                //是	汇总人	    oa审批人（电商）
                //是	订单状态	订单状态枚举值
                uocSendEcPlatOrderBO.setSaleOrderState(result.getSaleOrderState());
                //是	订单状态翻译	订单状态翻译
                //是	订单明细总金额（元）	    销售总金额
                uocSendEcPlatOrderBO.setTotalSaleFee(result.getTotalSaleFee());
                //是	提交申购时间	下单时间
                uocSendEcPlatOrderBO.setOrderCreateTime(result.getCreateTime());
                //是	订单汇总时间	审批通过时间
                //是	商品计量单位	名称    商品单位名称
                uocSendEcPlatOrderBO.setUnitName(bo.getUnitName());
                //是	供应商	名称   供应商名称
                uocSendEcPlatOrderBO.setSupplierId(stock.getSupId());
                uocSendEcPlatOrderBO.setSupplierName(stock.getSupName());
                //是	订单类型	01工业品、00办公用品、02框架
                uocSendEcPlatOrderBO.setAreaType(result.getAreaType().toString());
                //是	采购单位	名称   公司名
                uocSendEcPlatOrderBO.setPurCompanyId(stock.getPurCompanyId());
                uocSendEcPlatOrderBO.setPurCompanyName(stock.getPurCompanyName());
                //是	采购单位编码（6位）	   会员
                //是	采购部门	名称  部门名称
                uocSendEcPlatOrderBO.setPurOrgId(stock.getPurOrgId());
                uocSendEcPlatOrderBO.setPurOrgName(stock.getPurOrgName());
                sendEcPlatOrderBOList.add(uocSendEcPlatOrderBO);
            }
            rspBO.setSendEcPlatOrderBOList(sendEcPlatOrderBOList);
        }

        return rspBO;
    }
}
