package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @description 销售单退款结果回调服务实现类
 * @author Luokan
 * @date 2022-09-29 3:38 PM
 **/
@Slf4j
@HTServiceImpl
public class UocUpdateSaleOrderReturnPayResultServiceImpl implements UocUpdateSaleOrderReturnPayResultService {

    protected static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private UocEsSyncManager uocEsSyncManager;

    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    /**
     * 1.销售单取消
     */
    public static final String  CANCLE_RETURN = "1";
    @Autowired
    private IUocAfOrderModel afOrderModel;

    /**
     * 销售单退款结果回调
     * @param reqBO
     * @return
     */
    @Override
    public UocUpdateSaleOrderReturnPayResultRspBO updateReturnPayResult(UocUpdateSaleOrderReturnPayResultReqBO reqBO) {
        //定义出参
        UocUpdateSaleOrderReturnPayResultRspBO rsp = UocRu.success(UocUpdateSaleOrderReturnPayResultRspBO.class);

        if (reqBO.getReturnPayResult()) {
            Integer payType = UocDicConstant.PAY_TYPE.PAY_BY_PERIOD;
            Long orderId = null;
            if (null != reqBO.getFscShouldPayId()) {
                //查询应付单
                UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
                uocOrderShouldPay.setFscShouldPayId(reqBO.getFscShouldPayId());
                UocOrderShouldPay result = this.iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
                if (null == result) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "未查询到该应付单");
                }
                payType = result.getPayType();
                orderId = result.getOrderId();
                /*//获取字典集合
                Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
                //判断是全部退款还是部分退款
                Integer payState = null;
                String payStateStr = null;
                if (reqBO.getPayBackAmount().compareTo(result.getPaidAmount()) == 0) {
                    payState = UocDicConstant.PAY_STATE.REFUSED;
                }else {
                    payState = UocDicConstant.PAY_STATE.PART_REFUSED;
                }
                //支付状态翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(payState)) {
                    payStateStr = dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(payState.toString());
                }*/
                //1)、修改应付单(退款金额)
                UocOrderShouldPay set = new UocOrderShouldPay();
                //支付状态->已完成
                set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
                //已退金额
                if (null == result.getBackAmount()) {
                    result.setBackAmount(BigDecimal.ZERO);
                }
                if (null != reqBO.getPayBackAmount()) {
                    set.setBackAmount(reqBO.getPayBackAmount().add(result.getBackAmount()));
                }
                //判断退款金额不能大于付款金额
                if (set.getBackAmount().compareTo(result.getPaidAmount()) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "退款总金额不能大于付款总金额");
                }
                set.setUpdateTime(new Date());
                UocOrderShouldPay where = new UocOrderShouldPay();
                where.setFscShouldPayId(reqBO.getFscShouldPayId());
                iUocPayOrderModel.modifyOrderShouldPayMain(set, where);
            }
            //根据验收数量来判断是部分退款，还是全部退款
            Integer saleOrderPayState = jargeSaleOrderPayState(reqBO.getSaleOrderId(), payType, orderId);
            //如果是销售单取消环节，同时没有真是付款，就更新为付款失败
            if (CANCLE_RETURN.equals(reqBO.getRefundNode()) && !reqBO.getRealPayResult()) {
                saleOrderPayState = UocDicConstant.PAY_STATE.FAILED;
            }
            //支付状态翻译
            String payStateStr = null;
            //获取字典集合
            Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(saleOrderPayState)) {
                payStateStr = dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(saleOrderPayState.toString());
            }
            //更新销售单状态
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
            //支付状态判断
            log.info("订单状态："+saleOrderPayState);
            //支付状态->已付款
            uocSaleOrderDo.setPayState(saleOrderPayState);
            iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
            //如果退款单据id不为空，还要更新退款单据的状态（售后单）
            if (null != reqBO.getRefundObjId() && 3 == reqBO.getRefundObjType()) {
                this.doModifyAfOrderPayState(reqBO.getSaleOrderId(), reqBO.getRefundObjId(), dictionaryMap);
            }
            //同步es
            syncEs(reqBO.getSaleOrderId(), saleOrderPayState, payStateStr);

        }else {
            //支付失败暂不处理
            //todo
        }

        return rsp;
    }

    /**
     * 如果退款单据id不为空，还要更新退款单据的状态（售后单）
     *
     * @param saleOrderId
     * @param refundObjId
     * @param dictionaryMap
     */
    private void doModifyAfOrderPayState(Long saleOrderId, Long refundObjId, Map<String, Map<String, String>> dictionaryMap) {
        Integer payState = UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED;
        //查询支付配置表，如果是账期则改为已更新应付金额
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderPayConfQryBo.setUserType(UocDicConstant.USE_TYPE.PUR);
        List<UocSaleOrderPayConf> saleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (CollectionUtils.isEmpty(saleOrderPayConfList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "采购侧支付配置查询为空");
        }
        if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(saleOrderPayConfList.get(0).getPayType())) {
            payState = UocDicConstant.PAY_AFTER_STATE.AMOUNT__DUE_UPDATED;
        }
        String payStateStr = null;
        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_AFTER_STATE.P_CODE))) {
            payStateStr = dictionaryMap.get(UocDicConstant.PAY_AFTER_STATE.P_CODE).get(payState.toString());
        }
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(refundObjId);
        uocAfOrderDo.setPayState(payState);
        uocAfOrderDo.setOrderId(saleOrderPayConfList.get(0).getOrderId());
        afOrderModel.modifyAfOrderState(uocAfOrderDo);
        //同步售后单es
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        //objId
        uocEsSyncManagerSaveDataReqBo.setObjId(refundObjId);
        //indexName
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getAfOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE, payState);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE_STR, payStateStr);
        //jsonObj
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("更新售后单支付状态uocEsSyncManagerSaveDataReqBo为{}", JSONObject.toJSONString(uocEsSyncManagerSaveDataReqBo));
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    /**
     * 根据验收数量来判断是部分退款，还是全部退款
     *
     * @param saleOrderId
     * @param payType
     * @param orderId
     * @return
     */
    private Integer jargeSaleOrderPayState(Long saleOrderId, Integer payType, Long orderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        List<UocSaleOrderItem> saleOrderItemList =  iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售明细查询为空");
        }
        Integer saleOrderPayState = UocDicConstant.PAY_STATE.REFUSED;
        for (UocSaleOrderItem bo : saleOrderItemList) {
            //拒收+退货数量 < 发货数量，则为部分退款
            BigDecimal returnPayCount = bo.getRefuseCount().add(bo.getReturnCount());
            if (bo.getSendCount().compareTo(returnPayCount) > 0) {
                saleOrderPayState = UocDicConstant.PAY_STATE.PART_REFUSED;
                break;
            }
        }
        //全部退款，还需要判断是否所有应付单都已经退款(非账期)
        if (UocDicConstant.PAY_STATE.REFUSED.equals(saleOrderPayState) && !UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(payType)) {
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setOrderId(orderId);
            List<UocOrderShouldPay> resultShouldPay = this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
            if (CollectionUtils.isEmpty(resultShouldPay)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询应付明细集合为空！");
            }
            for (UocOrderShouldPay bo : resultShouldPay) {
                if (null == bo.getBackAmount() || null == bo.getPaidAmount()) {
                    saleOrderPayState = UocDicConstant.PAY_STATE.PART_REFUSED;
                    break;
                }
                if (bo.getBackAmount().compareTo(bo.getPaidAmount()) < 0) {
                    saleOrderPayState = UocDicConstant.PAY_STATE.PART_REFUSED;
                    break;
                }
            }
        }

        return saleOrderPayState;
    }

    /**
     * 同步ES
     */
    private void syncEs(Long objId, Integer payState, String payStateStr) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        //objId
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        //indexName
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE, payState);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE_STR, payStateStr);
        //jsonObj
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("更新销售单支付状态uocEsSyncManagerSaveDataReqBo为{}", JSONObject.toJSONString(uocEsSyncManagerSaveDataReqBo));
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        //支付状态字典
        pCodeList.add(UocDicConstant.PAY_STATE.P_CODE);
        //售后单支付状态
        pCodeList.add(UocDicConstant.PAY_AFTER_STATE.P_CODE);
    }
}
