package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApplyDealInvoiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApplyDealInvoiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocApplyDealInvoiceServiceImpl
 * 说明：申请开票接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocApplyDealInvoiceServiceImpl implements UocApplyDealInvoiceService {

    /**
     * 销售单模型层
     */
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    /**
     * 申请开票
     */
    @Override
    public UocApplyDealInvoiceRspBo dealApplyDealInvoice(UocApplyDealInvoiceReqBo reqBo) {
        //定义销售单DO，参数转换
        UocSaleOrderDo invoiceUocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        //设置销售单发票状态
        invoiceUocSaleOrderDo.setInvoiceState(UocConstant.INVOICE_STATE.INVOICE_ING);

        //调用销售单模型层，申请开票，修改销售单数据
        this.iUocSaleOrderModel.dealApplyDealInvoice(invoiceUocSaleOrderDo);

        //出参
        return UocRu.success(UocApplyDealInvoiceRspBo.class);
    }
}
