package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapArrivalInspInfo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspInfoRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapInspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description sap验收信息回调接口
 * @author Luokan
 * @date 2024/07/08
 **/
@HTServiceImpl
public class UocDealSapInspInfoServiceImpl implements UocDealSapInspInfoService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocDealSapInspInfoRspBO dealSapInspInfo(UocDealSapInspInfoReqBO reqBO) {
        UocDealSapInspInfoRspBO rspBO = UocRu.success(UocDealSapInspInfoRspBO.class);
        //查询销售明细
        List<String> sapOrderItemNoList = reqBO.getRows().stream().map(UocSapInspBO::getEBELP).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSapOrderItemNoList(sapOrderItemNoList);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            Map<String, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSapOrderItemNo, Function.identity()));
            List<UocSapArrivalInspInfo> list = new ArrayList<>();
            for (UocSapInspBO bo : reqBO.getRows()) {
                //新增验收记录表
                UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(bo.getEBELP());
                UocSapArrivalInspInfo uocSapArrivalInspInfo = this.setSapArrivalInsp(bo, reqBO, saleOrderItem);
                list.add(uocSapArrivalInspInfo);
                iUocSaleOrderModel.insertSapArrivalInspBatch(list);
                //新增/修改临时验收信息表
                this.dealTempInsp(saleOrderItem, uocSapArrivalInspInfo);
            }
            rspBO.setOrderId(saleOrderItemList.get(0).getOrderId());
            rspBO.setSaleOrderId(saleOrderItemList.get(0).getSaleOrderId());
        }
        return rspBO;
    }

    private void dealTempInsp(UocSaleOrderItem saleOrderItem, UocSapArrivalInspInfo uocSapArrivalInspInfo) {
        //先查询临时验收表记录是否存在,并新增
        UocInspOrderTemporarily qryInspTemp = new UocInspOrderTemporarily();
        qryInspTemp.setOrderId(saleOrderItem.getOrderId());
        qryInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
        List<UocInspOrderTemporarily> resultInspTemp = this.iUocSaleOrderModel.selectTempInspOrderList(qryInspTemp);
        Long inspOrderTempId = null;
        if (CollectionUtils.isEmpty(resultInspTemp)) {
            //新增
            UocInspOrderTemporarily insertInspTemp = new UocInspOrderTemporarily();
            insertInspTemp.setTempInspOrderId(IdUtil.nextId());
            inspOrderTempId = insertInspTemp.getTempInspOrderId();
            insertInspTemp.setTempInspOrderNo("");
            insertInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspTemp.setOrderId(insertInspTemp.getOrderId());
            insertInspTemp.setStatus(UocConstant.TempInspOrderStatus.ERROR);
            insertInspTemp.setCreateTime(new Date());
            insertInspTemp.setRemark(uocSapArrivalInspInfo.getInspRemark());
            this.iUocSaleOrderModel.insertTempInspOrder(insertInspTemp);
        }else {
            inspOrderTempId = resultInspTemp.get(0).getTempInspOrderId();
        }
        //先查询零时验收明细信息是否存在，再新增或更新
        UocInspOrderItemTemporarily qryInspItemTepm = new UocInspOrderItemTemporarily();
        qryInspItemTepm.setOrderId(saleOrderItem.getOrderId());
        qryInspItemTepm.setSaleOrderId(saleOrderItem.getSaleOrderId());
        qryInspItemTepm.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
        List<UocInspOrderItemTemporarily> resultInspItemTemp = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryInspItemTepm);
        if (CollectionUtils.isEmpty(resultInspItemTemp)) {
            //新增
            UocInspOrderItemTemporarily insertInspItemTemp = new UocInspOrderItemTemporarily();
            insertInspItemTemp.setTempInspOrderItemId(IdUtil.nextId());
            insertInspItemTemp.setTempInspOrderId(inspOrderTempId);
            insertInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            insertInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspItemTemp.setOrderId(saleOrderItem.getSaleOrderId());
            insertInspItemTemp.setSapOrderNo(saleOrderItem.getSapOrderNo());
            insertInspItemTemp.setSapOrderItemNo(saleOrderItem.getSapOrderItemNo());
            insertInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            insertInspItemTemp.setInspCount(uocSapArrivalInspInfo.getInspCount());
            insertInspItemTemp.setReturnCount(BigDecimal.ZERO);
            insertInspItemTemp.setStatus(1);
            insertInspItemTemp.setCreateTime(new Date());
            this.iUocSaleOrderModel.insertTempInspOrderItem(insertInspItemTemp);
        }else {
            //更新
            UocInspOrderItemTemporarily updateInspItemTemp = new UocInspOrderItemTemporarily();
            updateInspItemTemp.setOrderId(saleOrderItem.getOrderId());
            updateInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateInspItemTemp.setInspCount(resultInspItemTemp.get(0).getInspCount().add(uocSapArrivalInspInfo.getInspCount()));
            updateInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            updateInspItemTemp.setUpdateTime(new Date());
            this.iUocSaleOrderModel.updateTempInspOrderItem(updateInspItemTemp);
        }
    }

    private UocSapArrivalInspInfo setSapArrivalInsp(UocSapInspBO bo, UocDealSapInspInfoReqBO reqBO, UocSaleOrderItem saleOrderItem) {
        UocSapArrivalInspInfo uocSapArrivalInspInfo = new UocSapArrivalInspInfo();
        //sap收货信息id
        uocSapArrivalInspInfo.setInspInfoId(IdUtil.nextId());
        //sap订单编号
        uocSapArrivalInspInfo.setSapOrderNo(bo.getEBELN());
        //sap订单明细编号
        uocSapArrivalInspInfo.setSapOrderItemNo(bo.getEBELP());
        //计划验收数量
        uocSapArrivalInspInfo.setPlanInspCount(new BigDecimal(bo.getMENGE()));
        //验收数量
        BigDecimal sacle = BigDecimal.ZERO;
        if (null != saleOrderItem.getUnitDigit()) {
            sacle = new BigDecimal(saleOrderItem.getUnitDigit());
        }
        BigDecimal inspCount = uocSapArrivalInspInfo.getPlanInspCount().divide(saleOrderItem.getPlanConversionRate(), sacle.intValue(), RoundingMode.HALF_UP);
        uocSapArrivalInspInfo.setInspCount(inspCount);
        //验收人名称
        uocSapArrivalInspInfo.setInspOperName(bo.getUSNAM_MKPF());
        //0：未处理 1：已处理
        uocSapArrivalInspInfo.setStatus(1);
        //物料凭证编号
        uocSapArrivalInspInfo.setSapVoucherNo(bo.getMBLNR());
        //物料凭证中的项目
        uocSapArrivalInspInfo.setSapVoucherItemNo(bo.getZEILE());
        //物料编码
        uocSapArrivalInspInfo.setMaterialCode(bo.getMATNR());
        //验收日期
        uocSapArrivalInspInfo.setInspTime(bo.getCPUDT_MKFP());
        //验收备注
        uocSapArrivalInspInfo.setInspRemark(bo.getXBLNR_MKPF());
        //能力平台能力名
        uocSapArrivalInspInfo.setPlatformName(reqBO.getPlatformName());
        //能力平台流水号
        uocSapArrivalInspInfo.setPlatformNo(reqBO.getPlatformNo());
        //创建时间
        uocSapArrivalInspInfo.setCreateTime(new Date());

        return uocSapArrivalInspInfo;
    }
}
