/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.saleorder.UocDealSapInspCheckService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspCheckReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspCheckRspBO;
import com.tydic.dyc.oc.transactionservice.UocArrvalAcceptanceTransaction;
import com.tydic.dyc.oc.transactionservice.UocEcArrvalAcceptanceTransaction;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealSapInspCheckService"})
public class UocDealSapInspCheckServiceImpl
implements UocDealSapInspCheckService {
    private static final Logger log = LoggerFactory.getLogger(UocDealSapInspCheckServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private UocArrvalAcceptanceTransaction uocArrvalAcceptanceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocEcArrvalAcceptanceTransaction uocEcArrvalAcceptanceTransaction;

    @PostMapping(value={"dealSapInspCheck"})
    public UocDealSapInspCheckRspBO dealSapInspCheck(@RequestBody UocDealSapInspCheckReqBO reqBO) {
        UocDealSapInspCheckRspBO rspBO = UocRu.success(UocDealSapInspCheckRspBO.class);
        Boolean inspFlag = this.checkInspFlag(reqBO);
        rspBO.setInspFlag(inspFlag);
        if (inspFlag.booleanValue()) {
            this.updateTempInsp(reqBO);
            this.buildInspParam(reqBO, rspBO);
        }
        return rspBO;
    }

    private void buildInspParam(UocDealSapInspCheckReqBO reqBO, UocDealSapInspCheckRspBO rspBO) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource())) {
            UocArrvalAcceptanceReqBo uocArrvalAcceptanceReqBo = new UocArrvalAcceptanceReqBo();
            uocArrvalAcceptanceReqBo.setOrderId(reqBO.getOrderId());
            uocArrvalAcceptanceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
            List<UocOrderTaskInst> saleOrderTask = this.getTaskInfo(reqBO.getOrderId(), reqBO.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
            String saleOrderTaskId = saleOrderTask.get(0).getTaskInstId();
            uocArrvalAcceptanceReqBo.setTaskId(saleOrderTaskId);
            List<UocOrderTaskInst> shipOrderTask = this.getTaskInfo(reqBO.getOrderId(), null, UocDicConstant.OBJ_TYPE.SHIP);
            Map<Long, String> shipOrderTaskMap = shipOrderTask.stream().collect(Collectors.toMap(UocOrderTaskInst::getObjId, UocOrderTaskInst::getTaskInstId));
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
            uocShipOrderItemQryBo.setOrderId(reqBO.getOrderId());
            UocShipOrderDo shipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            Map<Long, List<UocShipOrderItem>> shipOrderMap = shipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.groupingBy(UocShipOrderItem::getShipOrderId));
            ArrayList<UocCreateInspOrderReqShipBo> shipOrderList = new ArrayList<UocCreateInspOrderReqShipBo>();
            ArrayList<String> shipTskIds = new ArrayList<String>();
            for (Long shipOrderId : shipOrderMap.keySet()) {
                UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo = new UocCreateInspOrderReqShipBo();
                uocCreateInspOrderReqShipBo.setShipOrderId(shipOrderId);
                uocCreateInspOrderReqShipBo.setTaskId(shipOrderTaskMap.get(shipOrderId));
                shipTskIds.add(uocCreateInspOrderReqShipBo.getTaskId());
                ArrayList<UocCreateInspOrderReqShipItemBo> shipItemList = new ArrayList<UocCreateInspOrderReqShipItemBo>();
                for (UocShipOrderItem shipOrderItem : shipOrderMap.get(shipOrderId)) {
                    UocCreateInspOrderReqShipItemBo uocCreateInspOrderReqShipItemBo = new UocCreateInspOrderReqShipItemBo();
                    uocCreateInspOrderReqShipItemBo.setShipItemId(shipOrderItem.getShipOrderItemId());
                    uocCreateInspOrderReqShipItemBo.setInspCount(shipOrderItem.getArriveCount());
                    shipItemList.add(uocCreateInspOrderReqShipItemBo);
                }
                uocCreateInspOrderReqShipBo.setShipItemList(shipItemList);
                shipOrderList.add(uocCreateInspOrderReqShipBo);
            }
            uocArrvalAcceptanceReqBo.setShipOrderList(shipOrderList);
            UocArrvalAcceptanceRspBo rspBo = this.uocArrvalAcceptanceTransaction.dealArrvalAcceptance(uocArrvalAcceptanceReqBo);
            if ("0000".equals(rspBo.getRespCode())) {
                this.syncAgrOrderEs(uocArrvalAcceptanceReqBo, rspBo);
            }
            rspBO.setShipTskIds(shipTskIds);
            rspBO.setTaskId(saleOrderTaskId);
            rspBO.setOrderSource(saleOrderDo.getOrderSource());
        } else {
            List<UocOrderTaskInst> saleOrderTask = this.getTaskInfo(reqBO.getOrderId(), reqBO.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
            String saleOrderTaskId = saleOrderTask.get(0).getTaskInstId();
            UocEcArrvalAcceptanceReqBo uocEcArrvalAcceptanceReqBo = new UocEcArrvalAcceptanceReqBo();
            uocEcArrvalAcceptanceReqBo.setOrderId(reqBO.getOrderId());
            uocEcArrvalAcceptanceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
            uocEcArrvalAcceptanceReqBo.setTaskId(saleOrderTaskId);
            UocEcArrvalAcceptanceRspBo rspBo = this.uocEcArrvalAcceptanceTransaction.dealEcArrvalAcceptance(uocEcArrvalAcceptanceReqBo);
            if ("0000".equals(rspBo.getRespCode())) {
                this.syncEcEs(uocEcArrvalAcceptanceReqBo, rspBo);
            }
        }
    }

    private void syncEcEs(UocEcArrvalAcceptanceReqBo reqBo, UocEcArrvalAcceptanceRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(inspBo);
        for (UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo : rspBo.getShipOrderList()) {
            SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
            shipBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            shipBo.setOrderId(reqBo.getOrderId());
            shipBo.setObjId(uocCreateInspOrderReqShipBo.getShipOrderId());
            shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(shipBo);
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    private void syncAgrOrderEs(UocArrvalAcceptanceReqBo reqBo, UocArrvalAcceptanceRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        SyncEsRunnableBo transactionBo = new SyncEsRunnableBo();
        transactionBo.setIndexName(this.uocIndexConfig.getTransactionIndex());
        transactionBo.setOrderId(reqBo.getOrderId());
        transactionBo.setObjId(rspBo.getInspOrderId());
        transactionBo.setJsonObj(reqBo.getJsonObj());
        transactionBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        transactionBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(transactionBo);
        list.add(saleBo);
        list.add(inspBo);
        log.debug("\u9a8c\u6536\u5355es\u540c\u6b65\uff1a" + JSON.toJSONString(list));
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    private List<UocOrderTaskInst> getTaskInfo(Long orderId, Long objId, Integer objType) {
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(orderId);
        qryInst.setObjId(objId);
        qryInst.setObjType(objType);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
        return uocOrderTaskInsts;
    }

    private void updateTempInsp(UocDealSapInspCheckReqBO reqBO) {
        UocInspOrderTemporarily updateUocInspOrderTemporarily = new UocInspOrderTemporarily();
        updateUocInspOrderTemporarily.setOrderId(reqBO.getOrderId());
        updateUocInspOrderTemporarily.setSaleOrderId(reqBO.getSaleOrderId());
        updateUocInspOrderTemporarily.setStatus(UocConstant.TempInspOrderStatus.COMPLETE);
        this.iUocSaleOrderModel.updateTempInspOrder(updateUocInspOrderTemporarily);
    }

    private Boolean checkInspFlag(UocDealSapInspCheckReqBO reqBO) {
        Boolean inspFlag = true;
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBO.getOrderId());
        uocAfOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocAfOrder> afOrderList = this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        if (!CollectionUtils.isEmpty(afOrderList)) {
            for (UocAfOrder afOrder : afOrderList) {
                if (Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.COMPLATE) || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.CANCEL) || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS)) continue;
                inspFlag = false;
            }
            if (!inspFlag.booleanValue()) {
                return inspFlag;
            }
        }
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocInspOrderItemTemporarily qryInspItemTepm = new UocInspOrderItemTemporarily();
        qryInspItemTepm.setOrderId(reqBO.getOrderId());
        qryInspItemTepm.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocInspOrderItemTemporarily> resultInspItemTemp = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryInspItemTepm);
        Map resultInspItemTempMap = resultInspItemTemp.stream().collect(Collectors.toMap(UocInspOrderItemTemporarily::getSaleOrderItemId, Function.identity()));
        for (UocSaleOrderItem bo : saleOrderItemList) {
            BigDecimal needInspCount;
            UocInspOrderItemTemporarily tempInspOrderItem = (UocInspOrderItemTemporarily)resultInspItemTempMap.get(bo.getSaleOrderItemId());
            BigDecimal tempInspCount = tempInspOrderItem.getInspCount().subtract(tempInspOrderItem.getReturnCount());
            if (tempInspCount.compareTo(needInspCount = bo.getArriveCount()) == 0) continue;
            inspFlag = false;
            break;
        }
        return inspFlag;
    }
}

