package com.tydic.dyc.oc.components.thread.runnable;

import com.tydic.dyc.base.constants.DycBaseLogConstant;
import lombok.Data;
import org.slf4j.MDC;

/**
 * 标题:LogTraceIdRunnable
 * 说明: 封装成带有日志traceId的Runnable对象
 * 时间:2023/9/8 0:23
 * 作者:田桂银
 */
@Data
public class LogTraceIdRunnable implements Runnable{

    private Runnable innerRunnable;
    private String logTraceId;

    public LogTraceIdRunnable(Runnable innerRunnable,String logTraceId) {
        this.innerRunnable = innerRunnable;
        this.logTraceId = logTraceId;
    }

    @Override
    public void run() {
        MDC.put(DycBaseLogConstant.X_B3_TraceId,this.logTraceId);
        innerRunnable.run();
    }
}


