package com.tydic.dyc.oc.model.order.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderAccessory
 * 说明:附件信息领域对象
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderAccessory implements Serializable {
	private static final long serialVersionUID =  -5643608881914957748L;

	//附件id")
	private Long id;

	//单据id      单据类型为1=订单时，不填")
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	//订单id")
	private Long orderId;

	//附件类型             0：合同附件             1：其他附件（供应商可见）             2：其他附件（项目单位可见）")
	private Integer attachmentType;

	//附件编号")
	private String accessoryId;

	//附件名称")
	private String accessoryName;

	//附件url")
	private String accessoryUrl;

	//附件存储位置             填附件的实际存储物理地址")
	private String attachmentStore;

	//创建时间")
	private Date createTime;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	

}
