package com.tydic.dyc.oc.model.saleorder.sub;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：临时验收明细表
 **/
@Data
public class UocInspOrderItemTemporarily implements Serializable {
	private static final long serialVersionUID =  2302859121656758241L;

	/**
	 * 临时验收单号
	 */
	private Long tempInspOrderItemId;
	/**
	 * 临时验收单id
	 */
	private Long tempInspOrderId;
	/**
	 * 临时验收单id
	 */
	private List<Long> tempInspOrderIds;
	/**
	 * 销售明细id
	 */
	private Long saleOrderItemId;
	/**
	 * 销售单id
	 */
	private Long saleOrderId;
	/**
	 * 订单id
	 */
	private Long orderId;
	/**
	 * sap订单编号
	 */
	private String sapOrderNo;
	/**
	 * sap订单明细编号
	 */
	private String sapOrderItemNo;
	/**
	 * 发货数量
	 */
	private BigDecimal sendCount;
	/**
	 * 验收数量
	 */
	private BigDecimal inspCount;
	/**
	 * sap 验收数量
	 */
	private BigDecimal planInspCount;
	/**
	 * 退货数量
	 */
	private BigDecimal returnCount;
	/**
	 * 状态0 异常验收  1 已验收
	 */
	private Integer status;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 更新时间
	 */
	private Date updateTime;
	private Date updateTimeStart;
	private Date updateTimeEnd;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 排序
	 */
	private String orderBy;

	/**
	 * 销售明细ID集合
	 */
	private List<Long> saleOrderItemIdList;

}
