package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.*;

/**
 * 标题：类名称:UocCmpOrderRepository
 * 说明：比价单
 * 时间：2022/3/29 11:21
 * 作者 @author 尹栋梁
 */
public interface UocCmpOrderRepository {

    /**
     * 创建比价单
     *
     * @param uocCmpOrderDo
     */
    void createCmpOrder(UocCmpOrderDo uocCmpOrderDo);

    /***
     * 查询比价单详情
     * @param uocCmpOrderDo
     * @return
     */
    UocCmpOrderQryBo qryCmpOrder(UocCmpOrderQryBo uocCmpOrderDo);

    /***
     * 通过比价单编号查询比价单（检查重复no）
     * @param uocCmpOrderDo
     * @return
     */
    Integer getCheckBy(UocCmpOrderDo uocCmpOrderDo);

    /**
     * 描述:根据采购用户id和单品id查询比选单号（）
     * @param qryBo  入参
     * @return void
     * @author tgy
     * @date 2023/1/4 16:19
     */
    UocQryCmpOrderNoBo qryCmpOrderNoBySkuIdAndUserId(UocQryCmpOrderNoBo qryBo);

    /**
     * 描述：删除比选单明细
     * @param uocDelCmpOrderBo
     */
    int dealCmpOrder(UocDelCmpOrderBo uocDelCmpOrderBo);

    int updateCmpOrder(UocUpdateCmpOrderBo uocUpdateCmpOrderBo);

    /**
     * 描述:查询当前用户当前商品已有的最新比价单号
     *
     * @param qryBo
     * @return
     */
    UocQryCmpOrderNoBo qryAlreadyHaveCmpOrderNo(UocQryCmpOrderNoBo qryBo);
}
