package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocQryCmpOrderNoBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetAlreadyHaveCmpOrderNoServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocGetAlreadyHaveCmpOrderNoServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述:〈领域服务-查询当前用户当前商品已有的最新比价单号〉
 *
 * @author : lihulin
 * @date : 2024/01/18 14:30
 */
@HTServiceImpl
public class UocGetAlreadyHaveCmpOrderNoServiceImpl implements UocGetAlreadyHaveCmpOrderNoService {

    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;

    @Override
    public UocGetAlreadyHaveCmpOrderNoServiceRspBo qryAlreadyHaveCmpOrderNo(UocGetAlreadyHaveCmpOrderNoServiceReqBo reqBo) {

        //入参校验
        this.validate(reqBo);

        UocQryCmpOrderNoBo qryBO = new UocQryCmpOrderNoBo();
        qryBO.setCreateOperId(reqBo.getUserId().toString());
        //qryBO.setUsername(reqBo.getUsername());
        qryBO.setSkuId(reqBo.getSkuId());
        UocQryCmpOrderNoBo uocQryCmpOrderNoBo = uocCmpOrderModel.qryAlreadyHaveCmpOrderNo(qryBO);


        UocGetAlreadyHaveCmpOrderNoServiceRspBo rspBO = new UocGetAlreadyHaveCmpOrderNoServiceRspBo();
        if (uocQryCmpOrderNoBo != null) {
            rspBO.setCmpOrderNo(uocQryCmpOrderNoBo.getCmpOrderNo());
        }
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }


    private void validate(UocGetAlreadyHaveCmpOrderNoServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo)) {
            throw new ZTBusinessException("入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new ZTBusinessException("入参【userId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSkuId())) {
            throw new ZTBusinessException("入参【skuId】不能为空");
        }
    }

}
