package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderFinishConfirmTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocAfterOrderFinishConfirmServiceImpl
 * 说明:售后完成确认
 * 时间:2022-05-13 13:54:43
 * 作者:luoyou
 */

@HTServiceImpl
public class UocAfterOrderFinishConfirmServiceImpl implements UocAfterOrderFinishConfirmService {
    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    @Autowired
    private UocAfterOrderFinishConfirmTransaction uocAfterOrderFinishConfirmTransaction;

    @Override
    public UocAfterOrderFinishConfirmRspBo finishConfirmAfterOrder(UocAfterOrderFinishConfirmReqBo reqBo) {

        UocAfterOrderFinishConfirmRspBo rspBo = this.uocAfterOrderFinishConfirmTransaction.finishConfirmAfterOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocAfterOrderFinishConfirmReqBo reqBo, UocAfterOrderFinishConfirmRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //定义销售单数据同步BO
        SyncEsRunnableBo syncSaleEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        //设置订单ID
        syncSaleEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncSaleEsRunnableBo.setObjId(rspBo.getSaleOrderId());
        //设置操作标识
        syncSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncSaleEsRunnableBo);

        //定义发货单数据同步BO
        SyncEsRunnableBo syncShipEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        //设置订单ID
        syncShipEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncShipEsRunnableBo.setObjId(rspBo.getShipOrderId());
        //设置操作标识
        syncShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncShipEsRunnableBo);

        //定义售后单数据同步BO
        SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        //设置订单ID
        syncAfEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncAfEsRunnableBo.setObjId(reqBo.getAfOrderId());
        //设置操作标识
        syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncAfEsRunnableBo);

        //批量发货单同步
        for (Long shipOrderId : rspBo.getShipOrderIdList()) {
            //定义发货单数据同步BO
            SyncEsRunnableBo syncBatchShipEsRunnableBo = new SyncEsRunnableBo();
            //设置索引名称
            syncBatchShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            //设置订单ID
            syncBatchShipEsRunnableBo.setOrderId(reqBo.getOrderId());
            //设置对象ID
            syncBatchShipEsRunnableBo.setObjId(shipOrderId);
            //设置操作标识
            syncBatchShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

            //添加到数据同步BO集合
            syncEsRunnableBoList.add(syncBatchShipEsRunnableBo);
        }

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
