package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocPayOrderCallbackReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPayOrderCallbackRspBo;
import com.tydic.dyc.oc.transactionservice.UocPayOrderCallbackTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：订单在线支付回调信息处理接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocPayOrderCallbackServiceImpl implements UocPayOrderCallbackService {

	/**
	 * 索引配置
	 */
	@Autowired
	private UocIndexConfig uocIndexConfig;

	/**
	 * 统一线程池
	 */
	@Autowired
	private UocThreadPool uocThreadPool;

	/**
	 * 订单在线支付回调信息处理事务层
	 */
	@Autowired
	private UocPayOrderCallbackTransaction uocPayOrderCallbackTransaction;

	/**
	 * 订单在线支付回调信息处理
	 */
	@Override
	public UocPayOrderCallbackRspBo dealPayOrderCallback(UocPayOrderCallbackReqBo reqBo) {
		//调用订单在线支付回调信息处理事务层，订单在线支付回调信息处理
		UocPayOrderCallbackRspBo rspBo = this.uocPayOrderCallbackTransaction.dealPayOrderCallback(reqBo);

		if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
			//调用同步ES
			this.syncEs(reqBo, rspBo);
		}

		return rspBo;
	}

	/**
	 * 同步ES
	 */
	private void syncEs(UocPayOrderCallbackReqBo reqBo, UocPayOrderCallbackRspBo rspBo) {
		//定义数据同步BO集合
		List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

		//定义数据同步BO
		SyncEsRunnableBo syncEsRunnableBo = new SyncEsRunnableBo();
		//设置索引名称
		syncEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
		//设置订单ID
		syncEsRunnableBo.setOrderId(rspBo.getOrderId());
		//设置对象ID
		syncEsRunnableBo.setObjId(rspBo.getSaleOrderId());
		//设置操作标识
		syncEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

		//添加到数据同步BO集合
		syncEsRunnableBoList.add(syncEsRunnableBo);

		//调用统一线程池
		this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
	}

}
