package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocTransactionPrice;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryTransactionPriceReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryTransactionPriceRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocTransactionPriceBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description 订单中心成交价查询api
 * @author Luokan
 * @date 2024/05/14
 **/
@HTServiceImpl
public class UocQryTransactionPriceServiceImpl implements UocQryTransactionPriceService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQryTransactionPriceRspBO qryTransactionPrice(UocQryTransactionPriceReqBO reqBO) {
        UocQryTransactionPriceRspBO rspBO = new UocQryTransactionPriceRspBO();
        List<UocTransactionPriceBO> transactionPriceBOList = new ArrayList<>();
        UocTransactionPrice qryReqBO = new UocTransactionPrice();
        qryReqBO.setSkuId(reqBO.getSkuId());
        qryReqBO.setCreateStartTime(reqBO.getCreateStartTime());
        qryReqBO.setCreateEndTime(reqBO.getCreateEndTime());
        List<UocTransactionPrice> result = this.iUocSaleOrderModel.qryTransactionPrice(qryReqBO);
        if (!CollectionUtils.isEmpty(result)) {
            transactionPriceBOList = result.stream().map(bo -> {
                UocTransactionPriceBO uocTransactionPriceBO = new UocTransactionPriceBO();
                uocTransactionPriceBO.setAvgFee(bo.getAvgFee());
                uocTransactionPriceBO.setMinFee(bo.getMinFee());
                uocTransactionPriceBO.setStatisticsDate(bo.getStatisticsDate());
                return uocTransactionPriceBO;
            }).collect(Collectors.toList());
        }
        rspBO.setTransactionPriceBOList(transactionPriceBOList);
        return rspBO;
    }
}
