package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealPurConfirmReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealPurConfirmRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description 京能协议待确认接口
 * @author Luokan
 * @date 2024/07/10
 **/
@HTServiceImpl
public class UocDealPurConfirmServiceImpl implements UocDealPurConfirmService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocDealPurConfirmRspBO dealPurConfirm(UocDealPurConfirmReqBO reqBO) {
        UocDealPurConfirmRspBO rspBO = new UocDealPurConfirmRspBO();

        //更新销售单主体信息,供应商确认/拒单人，确认/拒单时间，拒单原因
        UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
        updateUocSaleOrderDo.setOrderId(reqBO.getOrderId());
        updateUocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        updateUocSaleOrderDo.setRejectOperId(String.valueOf(reqBO.getUserId()));
        updateUocSaleOrderDo.setRejectOperName(reqBO.getName());
        updateUocSaleOrderDo.setRejectTime(new Date());
        updateUocSaleOrderDo.setRejectReason(reqBO.getRefuseReason());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrderDo);

        //提交任务
        this.commitTask(reqBO);
        /*//查询销售单，用于回退预算
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBO, UocSaleOrderQryBo.class);
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);*/
        rspBO.setSaleOrderId(reqBO.getSaleOrderId());

        //查询销售明细，用于回退预算
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBO, UocSaleOrderItemQryBo.class);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        //销售单明细
        List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = UocRu.jsl(saleOrderItemList, UocGetSaleOrderDetailServiceRspItemBo.class);
        rspBO.setUocGetSaleOrderDetailServiceRspItemBos(uocGetSaleOrderDetailServiceRspItemBos);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private void commitTask(UocDealPurConfirmReqBO reqBO) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBO.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBO.getUserId());
        uocCommonDo.setOrderId(reqBO.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }
}
