package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description sap验收信息回调接口
 * @author Luokan
 * @date 2024/07/08
 **/
@HTServiceImpl
public class UocDealSapInspInfoServiceImpl implements UocDealSapInspInfoService{

    private static final Logger log = LoggerFactory.getLogger(UocDealSapInspInfoServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private RedissonClient redissonClient;

    @Override
    public UocDealSapInspInfoRspBO dealSapInspInfo(UocDealSapInspInfoReqBO reqBO) {
        UocDealSapInspInfoRspBO rspBO = UocRu.success(UocDealSapInspInfoRspBO.class);
        List<String> sapOrderItemNoList = reqBO.getRows().stream().map(UocSapInspBO::getEbeln).collect(Collectors.toList());
        RLock lock = redissonClient.getLock(sapOrderItemNoList.get(0));
        log.info("获取锁:{}", sapOrderItemNoList.get(0));
        try {
            boolean b = lock.tryLock(3, 3, TimeUnit.SECONDS);
            log.info("获取锁结果:{}", b);
            if (b){
                //查询销售明细
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setSapOrderNoList(sapOrderItemNoList);
                List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                if (!CollectionUtils.isEmpty(saleOrderItemList)) {
                    Map<String, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSapOrderItemNo, Function.identity()));
                    List<UocSapArrivalInspInfo> list = new ArrayList<>();
                    for (UocSapInspBO bo : reqBO.getRows()) {
                        //新增验收记录表
                        UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(bo.getEbelp());
                        UocSapArrivalInspInfo uocSapArrivalInspInfo = this.setSapArrivalInsp(bo, reqBO, saleOrderItem);
                        list.add(uocSapArrivalInspInfo);
                        iUocSaleOrderModel.insertSapArrivalInspBatch(list);
                        //新增/修改临时验收信息表
                        this.dealTempInsp(saleOrderItem, uocSapArrivalInspInfo);
                        bo.setSynstatus("S");
                        bo.setSynstatus("成功");
                    }
                    rspBO.setOrderId(saleOrderItemList.get(0).getOrderId());
                    rspBO.setSaleOrderId(saleOrderItemList.get(0).getSaleOrderId());
                    rspBO.setRows(reqBO.getRows());
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }finally {
            if (lock!=null&&lock.isHeldByCurrentThread()){
                lock.unlock();
            }
        }
        return rspBO;
    }


    private void dealTempInsp(UocSaleOrderItem saleOrderItem, UocSapArrivalInspInfo uocSapArrivalInspInfo) {
        //先查询临时验收表记录是否存在,并新增
        UocInspOrderTemporarily qryInspTemp = new UocInspOrderTemporarily();
        qryInspTemp.setOrderId(saleOrderItem.getOrderId());
        qryInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
        List<UocInspOrderTemporarily> resultInspTemp = this.iUocSaleOrderModel.selectTempInspOrderList(qryInspTemp);
        Long inspOrderTempId = null;
        if (CollectionUtils.isEmpty(resultInspTemp)) {
            //新增
            UocInspOrderTemporarily insertInspTemp = new UocInspOrderTemporarily();
            insertInspTemp.setTempInspOrderId(IdUtil.nextId());
            inspOrderTempId = insertInspTemp.getTempInspOrderId();
            insertInspTemp.setTempInspOrderNo("");
            insertInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspTemp.setOrderId(saleOrderItem.getOrderId());
            insertInspTemp.setStatus(UocConstant.TempInspOrderStatus.ERROR);
            insertInspTemp.setCreateTime(new Date());
            insertInspTemp.setRemark(uocSapArrivalInspInfo.getInspRemark());
            this.iUocSaleOrderModel.insertTempInspOrder(insertInspTemp);
        }else {
            inspOrderTempId = resultInspTemp.get(0).getTempInspOrderId();
        }
        //先查询零时验收明细信息是否存在，再新增或更新
        UocInspOrderItemTemporarily qryInspItemTepm = new UocInspOrderItemTemporarily();
        qryInspItemTepm.setOrderId(saleOrderItem.getOrderId());
        qryInspItemTepm.setSaleOrderId(saleOrderItem.getSaleOrderId());
        qryInspItemTepm.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
        List<UocInspOrderItemTemporarily> resultInspItemTemp = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryInspItemTepm);
        if (CollectionUtils.isEmpty(resultInspItemTemp)) {
            //新增
            UocInspOrderItemTemporarily insertInspItemTemp = new UocInspOrderItemTemporarily();
            insertInspItemTemp.setTempInspOrderItemId(IdUtil.nextId());
            insertInspItemTemp.setTempInspOrderId(inspOrderTempId);
            insertInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            insertInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspItemTemp.setOrderId(saleOrderItem.getOrderId());
            insertInspItemTemp.setSapOrderNo(saleOrderItem.getSapOrderNo());
            insertInspItemTemp.setSapOrderItemNo(saleOrderItem.getSapOrderItemNo());
            insertInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            insertInspItemTemp.setInspCount(uocSapArrivalInspInfo.getInspCount());
            insertInspItemTemp.setPlanInspCount(uocSapArrivalInspInfo.getPlanInspCount());
            insertInspItemTemp.setReturnCount(BigDecimal.ZERO);
            insertInspItemTemp.setStatus(1);
            insertInspItemTemp.setCreateTime(new Date());
            this.iUocSaleOrderModel.insertTempInspOrderItem(insertInspItemTemp);
        }else {
            //更新
            UocInspOrderItemTemporarily updateInspItemTemp = new UocInspOrderItemTemporarily();
            updateInspItemTemp.setOrderId(saleOrderItem.getOrderId());
            updateInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            updateInspItemTemp.setInspCount(resultInspItemTemp.get(0).getInspCount().add(uocSapArrivalInspInfo.getInspCount()));
            updateInspItemTemp.setPlanInspCount(resultInspItemTemp.get(0).getPlanInspCount().add(uocSapArrivalInspInfo.getPlanInspCount()));
            updateInspItemTemp.setUpdateTime(new Date());
            this.iUocSaleOrderModel.updateTempInspOrderItem(updateInspItemTemp);
        }
    }

    private UocSapArrivalInspInfo setSapArrivalInsp(UocSapInspBO bo, UocDealSapInspInfoReqBO reqBO, UocSaleOrderItem saleOrderItem) {
        UocSapArrivalInspInfo uocSapArrivalInspInfo = new UocSapArrivalInspInfo();
        //sap收货信息id
        uocSapArrivalInspInfo.setInspInfoId(IdUtil.nextId());
        //sap订单编号
        uocSapArrivalInspInfo.setSapOrderNo(bo.getEbeln());
        //sap订单明细编号
        uocSapArrivalInspInfo.setSapOrderItemNo(bo.getEbelp());
        //计划验收数量
        uocSapArrivalInspInfo.setPlanInspCount(new BigDecimal(bo.getMenge().trim()));
        //验收数量
//        BigDecimal sacle = BigDecimal.ZERO;
//        try {
//            if (null != saleOrderItem.getUnitDigit() && !saleOrderItem.getUnitDigit().isEmpty()) {
//                sacle = new BigDecimal(saleOrderItem.getUnitDigit());
//            }
//        }catch (Exception e) {
//
//        }
        BigDecimal inspCount = uocSapArrivalInspInfo.getPlanInspCount().divide(saleOrderItem.getPlanConversionRate(), 6, RoundingMode.HALF_UP);
        uocSapArrivalInspInfo.setInspCount(inspCount);
        //验收人名称
        uocSapArrivalInspInfo.setInspOperName(bo.getUsnam_mkpf());
        //0：未处理 1：已处理
        uocSapArrivalInspInfo.setStatus(1);
        //物料凭证编号
        uocSapArrivalInspInfo.setSapVoucherNo(bo.getMblnr());
        //物料凭证中的项目
        uocSapArrivalInspInfo.setSapVoucherItemNo(bo.getZeile());
        //物料编码
        uocSapArrivalInspInfo.setMaterialCode(bo.getMatnr());
        //验收日期
        uocSapArrivalInspInfo.setInspTime(bo.getCpudt_mkfp());
        //验收备注
        uocSapArrivalInspInfo.setInspRemark(bo.getXblnr_mkpf());
        //能力平台能力名
        uocSapArrivalInspInfo.setPlatformName(reqBO.getPlatformName());
        //能力平台流水号
        uocSapArrivalInspInfo.setPlatformNo(reqBO.getPlatformNo());
        //创建时间
        uocSapArrivalInspInfo.setCreateTime(new Date());

        return uocSapArrivalInspInfo;
    }



    @Override
    public List<UocSapInspTaskBO> dealSapInspTask(List<UocSapInspTaskBO> uocSapInspTaskBOS) {
        for (UocSapInspTaskBO uocSapInspTaskBO : uocSapInspTaskBOS) {
            UocSapInspTask uocSapInspTask = new UocSapInspTask();
            BeanUtils.copyProperties(uocSapInspTaskBO, uocSapInspTask);
            uocSapInspTask.setId(IdUtil.nextId());
            uocSapInspTask.setCreatedDate(new Date());
            this.iUocSaleOrderModel.insertSapInspTask(uocSapInspTask);
            uocSapInspTaskBO.setSynresult("成功");
            uocSapInspTaskBO.setSynstatus("S");
        }
        return uocSapInspTaskBOS;
    }

    @Override
    public List<UocSapInspResultBO> dealSapInspResult(List<UocSapInspResultBO> uocSapInspResultBOS) {
        for (UocSapInspResultBO uocSapInspResultBO : uocSapInspResultBOS) {
            UocSapInspResult uocSapInspResult = new UocSapInspResult();
            BeanUtils.copyProperties(uocSapInspResultBO, uocSapInspResult);
            uocSapInspResult.setId(IdUtil.nextId());
            uocSapInspResult.setCreatedDate(new Date());
            this.iUocSaleOrderModel.insertSapInspResult(uocSapInspResult);
            uocSapInspResultBO.setSynresult("成功");
            uocSapInspResultBO.setSynstatus("S");
        }
        return uocSapInspResultBOS;
    }
}
