package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderMaterialServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderMaterialServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Description:获取物料信息
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/28 17:12
 */
@Slf4j
@HTServiceImpl
public class UocGetSaleOrderMaterialServiceImpl implements UocGetSaleOrderMaterialService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;


    @Override
    public UocGetSaleOrderMaterialServiceRspBo getSaleOrderItems(UocGetSaleOrderMaterialServiceReqBo reqBo) {
        UocGetSaleOrderMaterialServiceRspBo rspBo = new UocGetSaleOrderMaterialServiceRspBo();
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSkuId(reqBo.getSkuId());
        List<String> Materials =  iUocSaleOrderModel.getMaterialBySkuId(uocSaleOrderQryBo);
        rspBo.setMaterialList(Materials);
        rspBo.setSkuId(reqBo.getSkuId());
        return  rspBo;
    }
}