package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSapOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryCancelSapOrderInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryCancelSapOrderInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @description sap订单取消信息查询接口
 * @author Luokan
 * @date 2024/07/08
 **/
@HTServiceImpl
public class UocQryCancelSapOrderInfoServiceImpl implements UocQryCancelSapOrderInfoService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Override
    public UocQryCancelSapOrderInfoRspBO qryCancelSapOrderInfo(UocQryCancelSapOrderInfoReqBO reqBO) {
        UocQryCancelSapOrderInfoRspBO rspBO = new UocQryCancelSapOrderInfoRspBO();
        //查询销售明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);

        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            List<UocCancelSapOrderBO> cancelSapOrderBOList = new ArrayList<>();
            for (UocSaleOrderItem bo : saleOrderItemList) {
                UocCancelSapOrderBO uocCancelSapOrderBO = new UocCancelSapOrderBO();
                uocCancelSapOrderBO.setEbeln(bo.getSapOrderNo());
                uocCancelSapOrderBO.setEbelp(bo.getSapOrderItemNo());
                cancelSapOrderBOList.add(uocCancelSapOrderBO);
            }
            rspBO.setCancelSapOrderBOList(cancelSapOrderBOList);
        }
        return rspBO;
    }
}
