package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation = Propagation.REQUIRES_NEW)
public class UocSaleOrderDeleteTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    public UocSaleOrderDeleteServiceRspBo deleteSaleOrder(UocSaleOrderDeleteServiceReqBo reqBo) {
        //参数校验
        this.validateArg(reqBo);
        //查询销售单判断是否为空
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        BeanUtils.copyProperties(reqBo,uocSaleOrderQryBo);
        UocSaleOrderDo querySaleOrderResultDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if(null != querySaleOrderResultDo){
            //逻辑删除销售单
            UocSaleOrderDo deleteSaleOrderDo = new UocSaleOrderDo();
            BeanUtils.copyProperties(reqBo,deleteSaleOrderDo);
            this.iUocSaleOrderModel.deleteSaleOrder(deleteSaleOrderDo);
            //返回结果
            return UocRu.success(UocSaleOrderDeleteServiceRspBo.class);
        }else{
            //抛出业务异常
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_RESP_GET_OBJ_NO_ERROR, "该销售单不存在");
        }
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void validateArg(UocSaleOrderDeleteServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }

}
