package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocThirdApiCommonConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.ESBParamUtil;
import com.tydic.dyc.oc.utils.SslClientUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 标题:UocQryEsLogisticsInfoServiceImpl
 * 说明:查询电商物流信息服务
 * 时间:2022/3/10 16:26
 * 作者:tkl
 */
@HTServiceImpl
@Slf4j
public class UocQryEsLogisticsInfoServiceImpl implements UocQryEsLogisticsInfoService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    public static final String FIELD_CODE = "jdOrgId";
    @Value("${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;

    @Override
    public UocQryEsLogisticsInfoServiceRspBo qryEsLogisticsDataList(UocQryEsLogisticsInfoServiceReqBo reqBo) {
        UocQryEsLogisticsInfoServiceRspBo rspBo = UocRu.success(UocQryEsLogisticsInfoServiceRspBo.class);
        validateParams(reqBo);
        log.info("查询物流配送信息入参:{}", JSON.toJSONString(reqBo));
        return qryEsLogisData(reqBo, rspBo);
    }

    /**
     * 查询电商物流信息
     *
     * @param reqBo
     * @param rspBo
     * @return UocQryLogisticsInfoServiceRspBo
     */
    private UocQryEsLogisticsInfoServiceRspBo qryEsLogisData(UocQryEsLogisticsInfoServiceReqBo reqBo, UocQryEsLogisticsInfoServiceRspBo rspBo) {
        String dataAchiveTabSuffix = null;
        //查询订单主体
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        uocOrderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
        if(dataAchiveFlag) {
            if (Objects.isNull(uocOrderDo)) {
                dataAchiveTabSuffix = "_"+new SimpleDateFormat("yyyy").format((reqBo.getOrderId() >> 22) + 1420041600000L);
            }
        }
        try {
            //查询订单扩展
            List<UocOrderMap> mapList = getUocOrderMapList(reqBo,dataAchiveTabSuffix);
            //查询发货单
            UocShipOrderDo shipOrderDo = getShipOrderDo(reqBo,dataAchiveTabSuffix);
            //查询销售单
            UocSaleOrderDo saleOrderDo = getSaleOrderDo(shipOrderDo,dataAchiveTabSuffix);
            List<UocOrderStakeholderQryBo> ordStakeHolderList = null;
            if (null != saleOrderDo) {
                //查询三方信息
                ordStakeHolderList = getOrdStakeHolderList(saleOrderDo,dataAchiveTabSuffix);
                if (ObjectUtil.isEmpty(ordStakeHolderList)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_CALL_THIRD_SERVICE, "调用ESB查询配送信息服务接口异常：【未查询到该订单的三方信息】");
                }
            }
            UocEsbReqParamBO esbReqParam = new UocEsbReqParamBO();
            if (ObjectUtil.isNull(shipOrderDo)) {
                //查询订单外部关联信息
                List<UocOrderQueryIndex> indexList = getOrderQueryIndexList(reqBo,dataAchiveTabSuffix);
                if (ObjectUtil.isNotEmpty(indexList)) {
                    esbReqParam.setType(UocConstant.ORD_TYPE.PORD_OR_CORD);
                    esbReqParam.setOrderId(indexList.get(0).getOutObjId());
                    if (ordStakeHolderList != null) {
                        esbReqParam.setSupplierId(Long.valueOf(ordStakeHolderList.get(0).getSupId()));
                    }
                    if (ObjectUtil.isNotEmpty(mapList)) {
                        esbReqParam.setOrgId(mapList.get(0).getFieldValue());
                    }
                }
            } else {
                rspBo.setShipCompanyName(shipOrderDo.getShipCompanyName());
                if (ObjectUtil.isNotEmpty(shipOrderDo.getShipOrderNoExt())) {
                    esbReqParam.setOrderId(shipOrderDo.getShipOrderNoExt());
                } else {
                    //查询售后信息
                    List<UocAfOrder> afOrderList = getAfOrderList(shipOrderDo,dataAchiveTabSuffix);
                    if (ObjectUtil.isNotEmpty(afOrderList)) {
                        esbReqParam.setOrderId(afOrderList.get(0).getExtOrderId());
                    } else {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_AF_ORDER_RESP_GET_EXT_ORD_ID_ERROR, "查询售后单为空");
                    }
                }
                esbReqParam.setType(UocConstant.ORD_TYPE.SHIP_ORD);
                if (ordStakeHolderList != null) {
                    esbReqParam.setSupplierId(Long.valueOf(ordStakeHolderList.get(0).getSupId()));
                }
                if (ObjectUtil.isNotEmpty(mapList)) {
                    esbReqParam.setOrgId(mapList.get(0).getFieldValue());
                }
            }

            esbReqParam.setHsn(reqBo.getHsn());

            // 请求报文
            String reqStr = initPostStr(esbReqParam);
            //下发
            String returnString = SslClientUtil.doPost(UocOrderPropertiesUtil.getProperty(UocThirdApiCommonConstant.ESB_QRY_ORDER_TRACK_URL), reqStr);
            log.info("调用ESB查询配送信息接口响应报文:{}", returnString);
            if (ObjectUtil.isEmpty(returnString)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_THREE_DATA_NULL, "调用ESB查询配送信息接口响应报文为空");
            }
            // 解析返回的报文
            return resolveRsp(returnString, rspBo);
        } catch (Exception e) {
            log.error("调用ESB查询配送信息服务接口异常:{}", e);
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CALL_THIRD_SERVICE, "调用ESB查询配送信息服务接口异常");
        }
    }

    /**
     * 查询销售单主体
     *
     * @param shipOrderDo
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    private UocSaleOrderDo getSaleOrderDo(UocShipOrderDo shipOrderDo,String dataAchiveTabSuffix) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(shipOrderDo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(shipOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    /**
     * 售后单列表查询
     *
     * @param shipOrderDo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrder></>
     */
    private List<UocAfOrder> getAfOrderList(UocShipOrderDo shipOrderDo,String dataAchiveTabSuffix) {
        UocAfOrderQryBo qryBo = new UocAfOrderQryBo();
        qryBo.setOrderId(shipOrderDo.getOrderId());
        qryBo.setSaleOrderId(shipOrderDo.getSaleOrderId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocAfOrderModel.getAfOrderList(qryBo);
    }

    /**
     * 查询外部系统单号关联信息
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex></>
     */
    private List<UocOrderQueryIndex> getOrderQueryIndexList(UocQryEsLogisticsInfoServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocOrderQueryIndexQryBo qryBo = new UocOrderQueryIndexQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocOrderModel.qryOrderQueryIndexList(qryBo);
    }

    /**
     * 查询发货单
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.shiporder.UocShipOrderDo
     */
    private UocShipOrderDo getShipOrderDo(UocQryEsLogisticsInfoServiceReqBo reqBo,String dataAchiveTabSuffix) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        uocShipOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    /**
     * 查询订单扩展
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderMap></>
     */
    private List<UocOrderMap> getUocOrderMapList(UocQryEsLogisticsInfoServiceReqBo reqBo,String dataAchiveTabSuffix) {
        UocOrderMapQryBo uocOrderMapQryBo = new UocOrderMapQryBo();
        uocOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocOrderMapQryBo.setFieldCode(FIELD_CODE);
        uocOrderMapQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocOrderModel.qryOrderMapList(uocOrderMapQryBo);
    }

    /**
     * 查询三方信息
     *
     * @param saleOrderDo
     * @return java.util.List<com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo></>
     */
    private List<UocOrderStakeholderQryBo> getOrdStakeHolderList(UocSaleOrderDo saleOrderDo, String dataAchiveTabSuffix) {
        UocOrderStakeholderQryBo stakeholderQryBo = new UocOrderStakeholderQryBo();
        stakeholderQryBo.setOrderId(saleOrderDo.getOrderId());
        stakeholderQryBo.setStakeholderId(saleOrderDo.getStakeholderId());
        stakeholderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocOrderModel.qryStakeholderList(stakeholderQryBo);
    }

    /**
     * ESB接口入参组装
     *
     * @param reqParam 入参对象BO
     * @return String
     */
    private String initPostStr(UocEsbReqParamBO reqParam) {
        String esbReqParam;
        log.info("查询电商物流信息|供应商ID: {}", reqParam.getSupplierId());
        // 根据供应商ID查找HSN
        String hsn = UocOrderPropertiesUtil.getProperty(UocThirdApiCommonConstant.SUPPLIER_ID + reqParam.getSupplierId());
        log.info("查询电商物流信息|hsn: {}", hsn);
//        if(hsn.equals("jd")) reqParam.setJdOrderId(reqParam.getOrderId());
        if(UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(reqParam.getSupplierId())){
            reqParam.setJdOrderId(reqParam.getOrderId());
        }

        if (ObjectUtil.isEmpty(hsn)) {
            hsn = reqParam.getHsn();
        }

        esbReqParam = ESBParamUtil.getEsbReqParam(reqParam, hsn, UocThirdApiCommonConstant.BUSINESS_ORDER);
        log.info("调用配送信息查询ESB接口请求报文：{}", esbReqParam);
        return esbReqParam;
    }


    /**
     * ESB返回数据解析
     *
     * @param returnString ESB接口返回数据
     * @return UocQryLogisticsInfoServiceRspBo
     */
    private UocQryEsLogisticsInfoServiceRspBo resolveRsp(String returnString, UocQryEsLogisticsInfoServiceRspBo rspBo) {
        log.info("调用配送信息查询ESB接口返回数据：{}", returnString);
        JSONObject jsonObject = JSONObject.parseObject(returnString);
        if (jsonObject.getBoolean(UocThirdApiCommonConstant.ESB_SUCCESS)) {
            if (UocRspConstants.RSP_CODE_SUCCESS.equals(jsonObject.get(UocThirdApiCommonConstant.ESB_RESULT_CODE))) {
                String jsonStr = JSONObject.toJSONString(jsonObject.get("result"));
                if (ObjectUtil.isNotEmpty(jsonStr)) {
                    JSONObject object = JSONObject.parseObject(jsonStr);
                    String orderTrack = JSONObject.toJSONString(object.get(UocConstant.RESPONSE_PARAMS.ORDER_TRACK));
                    String orderId = (String) JSONObject.parseObject(jsonStr).get(UocConstant.RESPONSE_PARAMS.ORDER_ID);
                    if (ObjectUtil.isNotEmpty(orderTrack)) {
                        List<OrderTrackInfoBO> orderTrackList = JSON.parseArray(orderTrack, OrderTrackInfoBO.class);
                        if (ObjectUtil.isNotEmpty(orderTrackList)) {
                            listSort(orderTrackList);
                            rspBo.setOrderTrackList(orderTrackList);
                        }

                    }
                    String waybillCode = object.getString(UocConstant.RESPONSE_PARAMS.WAY_BILL_CODE);
                    if (waybillCode != null) {
                        try {
                            JSONArray array = JSONArray.parseArray(waybillCode);
                            rspBo.setCarrier(array.getJSONObject(0).getString(UocConstant.RESPONSE_PARAMS.CARRIER));
                            rspBo.setDeliveryOrderId(array.getJSONObject(0).getString(UocConstant.RESPONSE_PARAMS.DELIVERY_ORDER_ID));
                        } catch (Exception e) {
                            try {
                                JSONObject code = JSONObject.parseObject(waybillCode);
                                rspBo.setCarrier(code.getString(UocConstant.RESPONSE_PARAMS.CARRIER));
                                rspBo.setDeliveryOrderId(code.getString(UocConstant.RESPONSE_PARAMS.DELIVERY_ORDER_ID));
                            } catch (Exception ignored) {
                                log.error("解析异常:{}", ignored.getMessage());
                            }
                        }
                    }
                    rspBo.setOrderId(orderId);
                }
            } else {
                rspBo.setRespCode(UocRspConstants.RSP_ERROR_CODE_CALL_THIRD_SERVICE);
                rspBo.setRespDesc("调用配送信息查询ESB接口失败" + jsonObject.get("resultMessage"));
            }
        }
        return rspBo;
    }

    /**
     * 按时间排序
     *
     * @param list 需要排序的入参
     */
    private void listSort(List<OrderTrackInfoBO> list) {
        Collections.sort(list, new Comparator<OrderTrackInfoBO>() {
            @Override
            public int compare(OrderTrackInfoBO o1, OrderTrackInfoBO o2) {
                try {
                    Date dt1 = DelFormatHelper.fromSdfToDate(o1.getMsgTime());
                    Date dt2 = DelFormatHelper.fromSdfToDate(o2.getMsgTime());
                    if (dt1.getTime() < dt2.getTime()) {
                        return 1;
                    } else if (dt1.getTime() > dt2.getTime()) {
                        return -1;
                    } else {
                        return 0;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return 0;
            }
        });
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    private void validateParams(UocQryEsLogisticsInfoServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryLogisticsInfoServiceReqBo]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单编号]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getShipOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货单id]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[类型]不能为空");
        }
    }

}


