package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.saleorder.bo.UocAlertInfoBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoRspBO;
import com.tydic.dyc.oc.transactionservice.UocDealAlertInfoTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @description 处理预警信息接口
 * @author Luokan
 * @date 2024/08/06
 **/
@Slf4j
@HTServiceImpl
public class UocDealAlertInfoServiceImpl implements UocDealAlertInfoService{

    @Autowired
    private UocDealAlertInfoTransaction uocDealAlertInfoTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocDealAlertInfoRspBO dealAlertInfoAdd(UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBo = uocDealAlertInfoTransaction.dealAlertInfoAdd(reqBO);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealAlertInfoReqBO reqBO, UocDealAlertInfoRspBO rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(rspBo.getUocAlertInfoBOList())) {
            for (UocAlertInfoBO bo : rspBo.getUocAlertInfoBOList()) {
                SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
                saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
                saleBo.setOrderId(bo.getOrderId());
                saleBo.setObjId(Long.valueOf(bo.getObjId()));
                saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(saleBo);
            }
        }
        log.debug("销售单es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    @Override
    public UocDealAlertInfoRspBO dealAlertInfoUpdate(UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBo = uocDealAlertInfoTransaction.dealAlertInfoUpdate(reqBO);
        return rspBo;
    }
}
