package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapOrderSendInfo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocBackSapOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderRspBO;
import com.tydic.dyc.oc.transactionservice.UocArrvalAcceptanceTransaction;
import com.tydic.dyc.oc.transactionservice.UocDealBackSapOrderTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description sap订单信息回调接口
 * @author Luokan
 * @date 2024/07/05
 **/
@Slf4j
@HTServiceImpl
public class UocDealBackSapOrderServiceImpl implements UocDealBackSapOrderService{

    @Autowired
    private UocDealBackSapOrderTransaction uocDealBackSapOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocDealBackSapOrderRspBO dealBackSapOrder(UocDealBackSapOrderReqBO reqBO) {
        UocDealBackSapOrderRspBO rspBo = uocDealBackSapOrderTransaction.dealBackSapOrder(reqBO);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(rspBo.getOrderId());
        saleBo.setObjId(rspBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);

        if (null != rspBo.getShipOrderId()) {
            SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
            shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipBo.setOrderId(rspBo.getOrderId());
            shipBo.setObjId(rspBo.getShipOrderId());
            shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(shipBo);
        }

        log.debug("验收单es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
