package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocSaleOrderDeleteTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单删除实现〉
 * @author : yuhao
 * @date : 2022/7/19 16:53
 */
@Slf4j
@HTServiceImpl
public class UocSaleOrderDeleteServiceImpl implements UocSaleOrderDeleteService {
    @Autowired
    private UocSaleOrderDeleteTransaction uocSaleOrderDeleteTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocSaleOrderDeleteServiceRspBo deleteSaleOrder(UocSaleOrderDeleteServiceReqBo reqBo) {
        UocSaleOrderDeleteServiceRspBo rspBo = uocSaleOrderDeleteTransaction.deleteSaleOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocSaleOrderDeleteServiceReqBo reqBo, UocSaleOrderDeleteServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);

        log.debug("验收单es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
