package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description:变更销售单oa 审批结果
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/27 16:37
 */
@Slf4j
@HTServiceImpl
public class UocSaleOrderUpdateOaInfoServiceImpl implements UocSaleOrderUpdateOaInfoService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Override
    public UocSaleOrderUpdateOaInfoRspBo updateSaleOrderOaInfo(UocSaleOrderUpdateOaInfoReqBo reqBo) {
        //参数校验
        this.validateArg(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOaAuditRemark(reqBo.getOaAuditRemark());
        uocSaleOrderDo.setOaAuditResult(reqBo.getOaAuditResult());
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        List<UocAttachmentUrlBO> attachmentUrlList = reqBo.getAttachmentUrlList();
        if (attachmentUrlList != null && !attachmentUrlList.isEmpty()) {
            List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList = new ArrayList<>();
            attachmentUrlList.forEach(e -> {
                UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo = new UocBaseOrderAccessoryAddBo();
                uocBaseOrderAccessoryAddBo.setAccessoryUrl(e.getUrl());
                uocBaseOrderAccessoryAddBo.setAccessoryName(e.getFileName());
                uocBaseOrderAccessoryAddBo.setAttachmentType(e.getAttachmentType());
                orderAccessoryBoList.add(uocBaseOrderAccessoryAddBo);
            });
            saveAccessoryInfo(orderAccessoryBoList, reqBo);
        }
        return UocRu.success(UocSaleOrderUpdateOaInfoRspBo.class);
    }

    /**
     * 保存附件
     *
     * @param reqBo
     */
    private void saveAccessoryInfo(List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList, UocSaleOrderUpdateOaInfoReqBo reqBo) {
        log.info("保存附件信息:{}", JSON.toJSONString(orderAccessoryBoList));
        List<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<>();
        for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : orderAccessoryBoList) {
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            BeanUtils.copyProperties(uocBaseOrderAccessoryAddBo, uocOrderAccessory);
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setObjId(reqBo.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setOrderId(reqBo.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.OA_APPROVAL_RESULT);
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }
    /**
     * 参数校验
     * @param reqBo
     */
    private void validateArg(UocSaleOrderUpdateOaInfoReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单号不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOaAuditResult() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "审批结果不能为空");
        }
    }


}
