package com.tydic.dyc.oc.model.snaporder;

import com.tydic.dyc.oc.model.snaporder.sub.UocSnapSaleOrderItem;
import com.tydic.dyc.oc.model.snaporder.sub.UocSnapSaleOrderItemSame;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：快照订单
 **/
@Data
public class UocSnapOrderDo implements Serializable {

	private static final long serialVersionUID =  -2859429639950176387L;

	/**
	 * 快照ID
	 */
	private Long snapshotId;

	/**
	 * 订单ID
	 */
	private Long orderId;

	/**
	 * 销售单ID
	 */
	private Long saleOrderId;

	/**
	 * 销售单编码
	 */
	private String saleOrderNo;

	/**
	 * 订单总金额
	 */
	private BigDecimal orderTotalFee;

	/**
	 * 供应商ID
	 */
	private String supplierId;

	/**
	 * 供应商名称
	 */
	private String supplierName;

	/**
	 * 订单来源 1自营单品 2电商导入 3协议生成
	 */
	private Integer orderSource;

	/**
	 * 专区类型
	 */
	private Integer areaType;

	/**
	 * 创建人机构ID
	 */
	private String createOrgId;

	/**
	 * 创建人机构名称
	 */
	private String createOrgName;

	/**
	 * 创建人公司ID
	 */
	private String createCompanyId;

	/**
	 * 创建人公司名称
	 */
	private String createCompanyName;

	/**
	 * 创建人工号
	 */
	private String createUserId;

	/**
	 * 创建人名称
	 */
	private String createUserName;

	/**
	 * 创建时间
	 */
	private Date createTime;

	/**
	 * 快照销售订单明细集合
	 */
	private List<UocSnapSaleOrderItem> uocSnapSaleOrderItemList;

}
