package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderConfirmOrRefuseTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderConfirmOrRefuseServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/7 20:30
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
@Slf4j
public class UocAfterOrderConfirmOrRefuseServiceImpl implements UocAfterOrderConfirmOrRefuseService {
    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    @Autowired
    private UocAfterOrderConfirmOrRefuseTransaction uocAfterOrderConfirmOrRefuseTransaction;
    
    @Override
    public UocAfterOrderConfirmOrRefuseRspBo dealAfterOrder(UocAfterOrderConfirmOrRefuseReqBo reqBo) {

        UocAfterOrderConfirmOrRefuseRspBo rspBo = this.uocAfterOrderConfirmOrRefuseTransaction.dealAfterOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocAfterOrderConfirmOrRefuseReqBo reqBo, UocAfterOrderConfirmOrRefuseRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //批量销售单同步
        if (!CollectionUtils.isEmpty(rspBo.getSaleOrderIdList())) {
            for (String saleOrderIdVsOrderIdStr : rspBo.getSaleOrderIdList()) {
                String[] saleOrderIdVsOrderIdArr = saleOrderIdVsOrderIdStr.split("-");
                long saleOrderId = Long.parseLong(saleOrderIdVsOrderIdArr[0]);
                long orderId = Long.parseLong(saleOrderIdVsOrderIdArr[1]);

                //定义销售单数据同步BO
                SyncEsRunnableBo syncBatchSaleEsRunnableBo = new SyncEsRunnableBo();
                //设置索引名称
                syncBatchSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
                //设置订单ID
                syncBatchSaleEsRunnableBo.setOrderId(orderId);
                //设置对象ID
                syncBatchSaleEsRunnableBo.setObjId(saleOrderId);
                //设置操作标识
                syncBatchSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

                //添加到数据同步BO集合
                syncEsRunnableBoList.add(syncBatchSaleEsRunnableBo);
            }
        }

        //批量发货单同步
        if (!CollectionUtils.isEmpty(rspBo.getShipOrderIdList())) {
            for (String shipOrderIdVsOrderIdStr : rspBo.getShipOrderIdList()) {
                String[] shipOrderIdVsOrderIdArr = shipOrderIdVsOrderIdStr.split("-");
                long shipOrderId = Long.parseLong(shipOrderIdVsOrderIdArr[0]);
                long orderId = Long.parseLong(shipOrderIdVsOrderIdArr[1]);

                //定义发货单数据同步BO
                SyncEsRunnableBo syncBatchShipEsRunnableBo = new SyncEsRunnableBo();
                //设置索引名称
                syncBatchShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
                //设置订单ID
                syncBatchShipEsRunnableBo.setOrderId(orderId);
                //设置对象ID
                syncBatchShipEsRunnableBo.setObjId(shipOrderId);
                //设置操作标识
                syncBatchShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

                //添加到数据同步BO集合
                syncEsRunnableBoList.add(syncBatchShipEsRunnableBo);
            }
        }

        //批量售后单同步
        if (!CollectionUtils.isEmpty(rspBo.getAfOrderIdList())) {
            for (String afOrderIdVsOrderIdStr : rspBo.getAfOrderIdList()) {
                String[] afOrderIdVsOrderIdArr = afOrderIdVsOrderIdStr.split("-");
                long afOrderId = Long.parseLong(afOrderIdVsOrderIdArr[0]);
                long orderId = Long.parseLong(afOrderIdVsOrderIdArr[1]);

                //定义售后单数据同步BO
                SyncEsRunnableBo syncBatchAfEsRunnableBo = new SyncEsRunnableBo();
                //设置索引名称
                syncBatchAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
                //设置订单ID
                syncBatchAfEsRunnableBo.setOrderId(orderId);
                //设置对象ID
                syncBatchAfEsRunnableBo.setObjId(afOrderId);
                //设置操作标识
                syncBatchAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

                //添加到数据同步BO集合
                syncEsRunnableBoList.add(syncBatchAfEsRunnableBo);
            }
        }

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }

}
