package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealUploadInvoiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealUploadInvoiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocDealUploadInvoiceTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：UocDealUploadInvoiceServiceImpl
 * 说明：上传发票处理接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocDealUploadInvoiceServiceImpl implements UocDealUploadInvoiceService {

    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    /**
     * 上传发票处理事务层
     */
    @Autowired
    private UocDealUploadInvoiceTransaction uocDealUploadInvoiceTransaction;

    /**
     * 上传发票处理
     */
    @Override
    public UocDealUploadInvoiceRspBo dealUploadInvoice(UocDealUploadInvoiceReqBo reqBo) {
        //调用上传发票处理事务层，上传发票处理
        UocDealUploadInvoiceRspBo rspBo = this.uocDealUploadInvoiceTransaction.dealUploadInvoice(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocDealUploadInvoiceReqBo reqBo, UocDealUploadInvoiceRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //定义数据同步BO
        SyncEsRunnableBo syncEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        //设置订单ID
        syncEsRunnableBo.setOrderId(rspBo.getOrderId());
        //设置对象ID
        syncEsRunnableBo.setObjId(rspBo.getSaleOrderId());
        //设置操作标识
        syncEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncEsRunnableBo);

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
