package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocInspTempAfProcessTaskDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocInspTempAfProcessTaskQryPageBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.UocDealSapInspCheckService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspCheckReqBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 标题：UocInspTempAfProcessTaskExecuteServiceImpl
 * 说明：临时验收售后处理任务执行接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocInspTempAfProcessTaskExecuteServiceImpl implements UocInspTempAfProcessTaskExecuteService {

    /**
     * 售后单模型层
     */
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    /**
     * sap验收信息校验接口
     */
    @Autowired
    private UocDealSapInspCheckService uocDealSapInspCheckService;

    /**
     * 执行临时验收售后处理任务
     */
    @Override
    public UocInspTempAfProcessTaskExecuteRspBo executeInspTempAfProcessTask(UocInspTempAfProcessTaskExecuteReqBo reqBo) {
        //入参转换
        UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo = UocRu.js(reqBo, UocInspTempAfProcessTaskDo.class);

        //调用售后单模型层，执行临时验收售后处理任务
        UocInspTempAfProcessTaskDo rspDo = this.iUocAfOrderModel.executeInspTempAfProcessTask(uocInspTempAfProcessTaskDo);

        //判断临时验收售后处理任务分页BO集合是否为空
        if (ObjectUtil.isNotEmpty(rspDo) && !CollectionUtils.isEmpty(rspDo.getTaskQryRspPageBoList())) {
            //循环sap验收信息校验
            for (UocInspTempAfProcessTaskQryPageBo bo : rspDo.getTaskQryRspPageBoList()) {
                //定义sap验收信息校验入参
                UocDealSapInspCheckReqBO uocDealSapInspCheckReqBO = new UocDealSapInspCheckReqBO();
                //设置订单ID
                uocDealSapInspCheckReqBO.setOrderId(bo.getOrderId());
                //设置销售订单ID
                uocDealSapInspCheckReqBO.setSaleOrderId(bo.getSaleOrderId());
                //调用sap验收信息校验接口
                this.uocDealSapInspCheckService.dealSapInspCheck(uocDealSapInspCheckReqBO);
            }
        }

        //出参
        return UocRu.success(UocInspTempAfProcessTaskExecuteRspBo.class);
    }
}
