package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusRspBo;
import com.tydic.dyc.oc.transactionservice.UocOrderSyncCheckStatusTransaction;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：UocOrderSyncCheckStatusServiceImpl
 * 说明：订单对账状态更新
 * 时间：2022/4/1 19:38
 *
 * @author 文乐
 */
@HTServiceImpl
@Slf4j
public class UocOrderSyncCheckStatusServiceImpl implements UocOrderSyncCheckStatusService{

    @Autowired
    private UocOrderSyncCheckStatusTransaction uocOrderSyncCheckStatusTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocOrderSyncCheckStatusRspBo dealSyncCheckStatus(UocOrderSyncCheckStatusReqBo reqBo) {
    
        UocOrderSyncCheckStatusRspBo rspBo = uocOrderSyncCheckStatusTransaction.dealSyncCheckStatus(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return UocRu.success(UocOrderSyncCheckStatusRspBo.class);
    }
    
    private void syncEs(UocOrderSyncCheckStatusReqBo reqBo, UocOrderSyncCheckStatusRspBo rspBo) {
        log.info("订单{}对账状态更新同步验收单{},",rspBo.getOrderId(),reqBo.getObjId());
        List<SyncEsRunnableBo> list = new ArrayList<>();
    
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(rspBo.getOrderId());
        inspBo.setObjId(reqBo.getObjId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(inspBo);
        
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}
