package com.tydic.dyc.oc.service.snaporder;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.snaporder.IUocSnapOrderModel;
import com.tydic.dyc.oc.model.snaporder.UocSnapOrderDo;
import com.tydic.dyc.oc.service.snaporder.bo.UocSnapshotOrderAddReqBo;
import com.tydic.dyc.oc.service.snaporder.bo.UocSnapshotOrderAddRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocSnapshotOrderAddServiceImpl
 * 描述：快照订单新增接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocSnapshotOrderAddServiceImpl implements UocSnapshotOrderAddService {

    /**
     * 快照订单领域方法服务
     */
    @Autowired
    private IUocSnapOrderModel iUocSnapOrderModel;

    /**
     * 快照订单新增
     */
    @Override
    public UocSnapshotOrderAddRspBo addSnapshotOrder(UocSnapshotOrderAddReqBo reqBo) {
        //定义出参对象
        UocSnapshotOrderAddRspBo rspBo = new UocSnapshotOrderAddRspBo();

        //定义快照单DO，参数转换
        UocSnapOrderDo uocSnapOrderDo = UocRu.js(reqBo, UocSnapOrderDo.class);

        //调用快照订单领域方法服务，创建快照单
        this.iUocSnapOrderModel.createSnapOrder(uocSnapOrderDo);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

}
