package com.tydic.dyc.oc.service.snaporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.snaporder.IUocSnapOrderModel;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListReqBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListRspBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.snaporder.bo.UocSnapshotOrderListQryBo;
import com.tydic.dyc.oc.service.snaporder.bo.UocSnapshotOrderListQryReqBo;
import com.tydic.dyc.oc.service.snaporder.bo.UocSnapshotOrderListQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：UocSnapshotOrderAddServiceImpl
 * 描述：订单快照列表分页查询接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocSnapshotOrderListQryServiceImpl implements UocSnapshotOrderListQryService {

    /**
     * 快照订单领域方法服务
     */
    @Autowired
    private IUocSnapOrderModel iUocSnapOrderModel;

    /**
     * 字典领域方法服务
     */
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    /**
     * 订单快照列表分页查询
     */
    @Override
    public UocSnapshotOrderListQryRspBo qryUocSnapshotOrderList(UocSnapshotOrderListQryReqBo reqBo) {
        //入参转换
        UocSnapshotOrderQryListReqBo uocSnapshotOrderQryListReqBo = UocRu.js(reqBo, UocSnapshotOrderQryListReqBo.class);

        //调用快照订单领域方法服务，订单快照列表分页查询
        UocSnapshotOrderQryListRspBo uocSnapshotOrderQryListRspBo = this.iUocSnapOrderModel.qryUocSnapshotOrderList(uocSnapshotOrderQryListReqBo);

        //出参转换
        UocSnapshotOrderListQryRspBo rspBo = UocRu.js(uocSnapshotOrderQryListRspBo, UocSnapshotOrderListQryRspBo.class);

        //数据转义
        this.qryUocSnapOrderListDataTranslation(rspBo);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        return rspBo;
    }

    /**
     * 数据转义
     */
    private void qryUocSnapOrderListDataTranslation(UocSnapshotOrderListQryRspBo rspBo) {
        //判断订单快照列表为空，直接返回
        if (CollectionUtils.isEmpty(rspBo.getRows())) {
            return;
        }

        //定义字典列表查询入参，字典编码集合
        List<String> pCodeList = new ArrayList<>(1);
        //设置专区类型字典编码
        pCodeList.add(UocConstant.SNAP_ORDER_DICTIONARY_P_CODE.AREA_TYPE);
        //设置是否低价字典编码
        pCodeList.add(UocConstant.SNAP_ORDER_DICTIONARY_P_CODE.IS_LOW_PRICE);
        //调用字典领域方法服务，查询字典列表
        Map<String, Map<String, String>> uocSysDictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);

        //获取专区类型字典Map
        Map<String, String> areaTypeDictionaryMap = uocSysDictionaryMap.get(UocConstant.SNAP_ORDER_DICTIONARY_P_CODE.AREA_TYPE);
        //获取是否同款最低价字典Map
        Map<String, String> isLowPriceDictionaryMap = uocSysDictionaryMap.get(UocConstant.SNAP_ORDER_DICTIONARY_P_CODE.IS_LOW_PRICE);

        //遍历订单快照列表，封装数据
        for (UocSnapshotOrderListQryBo row : rspBo.getRows()) {
            if (ObjectUtil.isNotEmpty(row.getAreaType())) {
                //设置专区类型转义
                row.setAreaTypeStr(areaTypeDictionaryMap.get(String.valueOf(row.getAreaType())));
            }
            if (ObjectUtil.isNotEmpty(row.getIsLowPrice())) {
                //设置是否同款最低价转义
                row.setIsLowPriceStr(isLowPriceDictionaryMap.get(String.valueOf(row.getIsLowPrice())));
            }
        }
    }

}
