/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocInspOrderModifyRemainInspCountService;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderModifyRemainInspCountReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderModifyRemainInspCountRspBo;
import com.tydic.dyc.oc.transactionservice.UocInspOrderModifyRemainInspCountTransaction;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocInspOrderModifyRemainInspCountService"})
public class UocInspOrderModifyRemainInspCountServiceImpl
implements UocInspOrderModifyRemainInspCountService {
    @Autowired
    private UocInspOrderModifyRemainInspCountTransaction uocInspOrderModifyRemainInspCountTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"modifyCount"})
    public UocInspOrderModifyRemainInspCountRspBo modifyCount(@RequestBody UocInspOrderModifyRemainInspCountReqBo reqBo) {
        UocInspOrderModifyRemainInspCountRspBo rspBo = this.uocInspOrderModifyRemainInspCountTransaction.modifyCount(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocInspOrderModifyRemainInspCountReqBo reqBo, UocInspOrderModifyRemainInspCountRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        for (Object uocChngOrderConfirmOrRefuseReqItemBo : reqBo.getChngOrderList()) {
            SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
            chngBo.setIndexName(this.uocIndexConfig.getChngOrderIndex());
            chngBo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            chngBo.setObjId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(chngBo);
        }
        List saleOrderIdList = rspBo.getSaleOrderIdList();
        for (String saleOrderId : saleOrderIdList) {
            String[] split = saleOrderId.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }
        List inspOrderIdList = rspBo.getInspOrderIdList();
        for (String inspOrderId : inspOrderIdList) {
            String[] split = inspOrderId.split("-");
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
            saleOrderBo.setOrderId(Long.valueOf(split[1]));
            saleOrderBo.setObjId(Long.valueOf(split[0]));
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

