/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocDealAlertInfoService;
import com.tydic.dyc.oc.service.saleorder.bo.UocAlertInfoBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoRspBO;
import com.tydic.dyc.oc.transactionservice.UocDealAlertInfoTransaction;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealAlertInfoService"})
public class UocDealAlertInfoServiceImpl
implements UocDealAlertInfoService {
    private static final Logger log = LoggerFactory.getLogger(UocDealAlertInfoServiceImpl.class);
    @Autowired
    private UocDealAlertInfoTransaction uocDealAlertInfoTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealAlertInfoAdd"})
    public UocDealAlertInfoRspBO dealAlertInfoAdd(@RequestBody UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBo = this.uocDealAlertInfoTransaction.dealAlertInfoAdd(reqBO);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealAlertInfoReqBO reqBO, UocDealAlertInfoRspBO rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        if (!CollectionUtils.isEmpty((Collection)rspBo.getUocAlertInfoBOList())) {
            for (UocAlertInfoBO bo : rspBo.getUocAlertInfoBOList()) {
                SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
                saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
                saleBo.setOrderId(bo.getOrderId());
                saleBo.setObjId(Long.valueOf(bo.getObjId()));
                saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(saleBo);
            }
        }
        log.debug("\u9500\u552e\u5355es\u540c\u6b65\uff1a" + JSON.toJSONString(list));
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    @PostMapping(value={"dealAlertInfoUpdate"})
    public UocDealAlertInfoRspBO dealAlertInfoUpdate(@RequestBody UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBo = this.uocDealAlertInfoTransaction.dealAlertInfoUpdate(reqBO);
        return rspBo;
    }
}

