/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderDeleteService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocSaleOrderDeleteTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderDeleteService"})
public class UocSaleOrderDeleteServiceImpl
implements UocSaleOrderDeleteService {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderDeleteServiceImpl.class);
    @Autowired
    private UocSaleOrderDeleteTransaction uocSaleOrderDeleteTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"deleteSaleOrder"})
    public UocSaleOrderDeleteServiceRspBo deleteSaleOrder(@RequestBody UocSaleOrderDeleteServiceReqBo reqBo) {
        UocSaleOrderDeleteServiceRspBo rspBo = this.uocSaleOrderDeleteTransaction.deleteSaleOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocSaleOrderDeleteServiceReqBo reqBo, UocSaleOrderDeleteServiceRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        log.debug("\u9a8c\u6536\u5355es\u540c\u6b65\uff1a" + JSON.toJSONString(list));
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

