/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelApplySaleOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocCancelApplySaleOrderTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocCancelApplySaleOrderTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocCancelApplySaleOrderRspBo cancelApplySaleOrder(UocCancelApplySaleOrderReqBo reqBo) {
        this.verifyParam(reqBo);
        UocSaleOrderDo queryUocSaleOrderDo = new UocSaleOrderDo();
        queryUocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        queryUocSaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderInfo = this.iUocSaleOrderModel.getSaleOrderMain(queryUocSaleOrderDo);
        if (null != saleOrderInfo) {
            Long changeOrderId = this.createCancelApplyChangeOrder(reqBo, saleOrderInfo);
            this.updateSaleOrderInfo(reqBo);
            UocCancelApplySaleOrderRspBo rspBo = new UocCancelApplySaleOrderRspBo();
            rspBo.setChngOrderId(changeOrderId);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        throw new BaseBusinessException("101009", "\u8be5\u9500\u552e\u5355\u4e0d\u5b58\u5728");
    }

    private Long createCancelApplyChangeOrder(UocCancelApplySaleOrderReqBo reqBo, UocSaleOrderDo saleOrderInfo) {
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        Long changeOrderId = IdUtil.nextId();
        String changeOrderNo = this.getChngOrderNo(saleOrderInfo.getOrderSource());
        UocChngOrderDo createChngOrderDo = new UocChngOrderDo();
        createChngOrderDo.setOrderId(reqBo.getOrderId());
        createChngOrderDo.setChngOrderId(changeOrderId);
        createChngOrderDo.setChngOrderNo(changeOrderNo);
        createChngOrderDo.setChngOrderState("CHNG_XS_QXSQZ");
        createChngOrderDo.setCancelReason(reqBo.getCancelReason());
        createChngOrderDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
        createChngOrderDo.setCancelOperName(reqBo.getName());
        createChngOrderDo.setCancelTime(new Date());
        createChngOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createChngOrderDo.setCreateOperName(reqBo.getName());
        createChngOrderDo.setCreateTime(new Date());
        createChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        Long changeOrderObjectId = IdUtil.nextId();
        ArrayList<UocChngOrderObj> createChngOrderObjList = new ArrayList<UocChngOrderObj>();
        UocChngOrderObj createChngOrderObj = new UocChngOrderObj();
        createChngOrderObj.setOrderId(reqBo.getOrderId());
        createChngOrderObj.setChngOrderObjId(changeOrderObjectId);
        createChngOrderObj.setChngOrderId(changeOrderId);
        createChngOrderObj.setChngType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        createChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        createChngOrderObj.setCreateTime(new Date());
        createChngOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createChngOrderObj.setOtherChngValue(saleOrderInfo.getSaleOrderState());
        ArrayList<UocChngOrderItemObj> createChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocChngOrderItemObj createChngOrderItem = new UocChngOrderItemObj();
            createChngOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            createChngOrderItem.setId(IdUtil.nextId());
            createChngOrderItem.setChngOrderId(changeOrderId);
            createChngOrderItem.setChngOrderObjId(changeOrderObjectId);
            createChngOrderItem.setOrderId(reqBo.getOrderId());
            createChngOrderItem.setCreateTime(new Date());
            createChngOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            createChngOrderItemObjList.add(createChngOrderItem);
        }
        createChngOrderObj.setUocChngOrderItemObjList(createChngOrderItemObjList);
        createChngOrderObjList.add(createChngOrderObj);
        createChngOrderDo.setUocChngOrderObjList(createChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            ArrayList<UocOrderAccessory> saveOrderAccessoryList = new ArrayList<UocOrderAccessory>();
            for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBo.getOrderAccessoryBoList()) {
                UocOrderAccessory createUocOrderAccessory = new UocOrderAccessory();
                BeanUtils.copyProperties((Object)uocBaseOrderAccessoryAddBo, (Object)createUocOrderAccessory);
                createUocOrderAccessory.setOrderId(reqBo.getOrderId());
                createUocOrderAccessory.setId(IdUtil.nextId());
                createUocOrderAccessory.setObjId(changeOrderId);
                createUocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                createUocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.CANCEL_APPLY_SALE_ORDER);
                createUocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                createUocOrderAccessory.setCreateTime(new Date());
                saveOrderAccessoryList.add(createUocOrderAccessory);
            }
            createChngOrderDo.setOrderAccessoryBoList(saveOrderAccessoryList);
        }
        this.iUocChngOrderModel.createChngOrder(createChngOrderDo);
        return changeOrderId;
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException("101009", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return saleOrderItemList;
    }

    private String getChngOrderNo(Integer orderSource2) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderQryBo.setOrderSource(orderSource2);
        UocChngOrderDo uocChngOrderResultDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        if (null != uocChngOrderResultDo) {
            return uocChngOrderResultDo.getChngOrderNo();
        }
        throw new BaseBusinessException("101009", "\u751f\u6210\u53d6\u6d88\u7533\u8bf7\u53d8\u66f4\u5355\u53f7\u5931\u8d25");
    }

    private void updateSaleOrderInfo(UocCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)updateSaleOrderDo));
        updateSaleOrderDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setCancelOperName(reqBo.getName());
        updateSaleOrderDo.setCancelRequestTime(new Date());
        updateSaleOrderDo.setSaleOrderState("XS_QX_QXSQ");
        this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
    }

    private void verifyParam(UocCancelApplySaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

