/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocConfirmReceiptShipOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UocShipOrderConfirmReceiptTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocShipOrderConfirmReceiptTransaction.class);
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocShipOrderConfirmReceiptRspBo dealConfirmReceipt(UocShipOrderConfirmReceiptReqBo reqBo) {
        UocShipOrderConfirmReceiptRspBo rspBo = new UocShipOrderConfirmReceiptRspBo();
        this.validateParam(reqBo);
        this.dealPayShipOrderInfo(reqBo);
        this.modifySaleOrderState(reqBo);
        this.submitTask(reqBo);
        List<UocShipOrderDo> shipOrderList = this.getShipOrderList(reqBo);
        rspBo.setUocConfirmReceiptShipOrderBOList(UocRu.jsl(shipOrderList, UocConfirmReceiptShipOrderBO.class));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateParam(UocShipOrderConfirmReceiptReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTaskId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u4efb\u52a1ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
    }

    private void modifySaleOrderState(UocShipOrderConfirmReceiptReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setSaleOrderState("XS_QR_QRSH");
        uocSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        uocSaleOrderDo.setCompleteRemark(reqBo.getCompleteRemark());
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    private void submitTask(UocShipOrderConfirmReceiptReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfoList = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>(1);
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskInfo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskInfo.setTaskId(reqBo.getTaskId());
        taskInfoList.add(taskInfo);
        uocCommonDo.setCompleteTaskInfos(taskInfoList);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void dealPayShipOrderInfo(UocShipOrderConfirmReceiptReqBo reqBo) {
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        this.iUocCommonModel.dealPayShipOrderInfo(uocShipOrderDo);
    }

    private List<UocShipOrderDo> getShipOrderList(UocShipOrderConfirmReceiptReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }
}

