/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.config.UocPropertiesConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleGoodsAfterTakeTypeBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemPlanBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItemPlan;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapArrivalInspInfo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapOrderSendInfo;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.repository.dao.SapArrivalInspInfoMapper;
import com.tydic.dyc.oc.repository.dao.SapOrderSendInfoMapper;
import com.tydic.dyc.oc.repository.dao.UocInspOrderItemTemporarilyMapper;
import com.tydic.dyc.oc.repository.dao.UocInspOrderTemporarilyMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderRelMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleAfterTakeTypeMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderItemPlanMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderPayConfMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleStakeholderMapper;
import com.tydic.dyc.oc.repository.po.SapArrivalInspInfoPO;
import com.tydic.dyc.oc.repository.po.SapOrderSendInfoPO;
import com.tydic.dyc.oc.repository.po.UocInspOrderItemTemporarilyPO;
import com.tydic.dyc.oc.repository.po.UocInspOrderTemporarilyPO;
import com.tydic.dyc.oc.repository.po.UocOrderAccessoryPo;
import com.tydic.dyc.oc.repository.po.UocOrderRelPo;
import com.tydic.dyc.oc.repository.po.UocSaleAfterTakeTypePo;
import com.tydic.dyc.oc.repository.po.UocSaleItemMapPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderItemPlanPO;
import com.tydic.dyc.oc.repository.po.UocSaleOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderPayConfPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderPo;
import com.tydic.dyc.oc.repository.po.UocSaleStakeholderPo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderPlanBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySapSendOrderLogReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapSendOrderLog;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocSaleOrderRepositoryImpl
implements UocSaleOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderRepositoryImpl.class);
    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;
    @Autowired
    private UocSaleOrderMapMapper uocSaleOrderMapMapper;
    @Autowired
    private UocSaleOrderPayConfMapper uocSaleOrderPayConfMapper;
    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;
    @Autowired
    private UocSaleItemMapMapper uocSaleItemMapMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocSaleStakeholderMapper uocSaleStakeholderMapper;
    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;
    @Autowired
    private UocSaleAfterTakeTypeMapper uocSaleAfterTakeTypeMapper;
    @Autowired
    private UocSaleOrderItemPlanMapper uocSaleOrderItemPlanMapper;
    @Autowired
    private SapOrderSendInfoMapper sapOrderSendInfoMapper;
    @Autowired
    private SapArrivalInspInfoMapper sapArrivalInspInfoMapper;
    @Autowired
    private UocInspOrderTemporarilyMapper uocInspOrderTemporarilyMapper;
    @Autowired
    private UocInspOrderItemTemporarilyMapper uocInspOrderItemTemporarilyMapper;
    @Autowired
    private UocPropertiesConfig uocPropertiesConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderMapper.insert((UocSaleOrderPo)UocRu.js((Object)saleOrderDo, UocSaleOrderPo.class));
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderMapList())) {
            this.uocSaleOrderMapMapper.insertBatch(UocRu.jsl((List)saleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderPayConfList())) {
            this.uocSaleOrderPayConfMapper.insertBatch(UocRu.jsl((List)saleOrderDo.getSaleOrderPayConfList(), UocSaleOrderPayConfPo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderAccessoryList())) {
            this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl((List)saleOrderDo.getSaleOrderAccessoryList(), UocOrderAccessoryPo.class));
        }
        if (saleOrderDo.getIsCreateServiceFee().booleanValue()) {
            this.createServiceFeeRel(saleOrderDo);
        }
        this.saveSaleItems(saleOrderDo);
        return saleOrderDo;
    }

    private void createServiceFeeRel(UocSaleOrderDo saleOrderDo) {
        UocOrderRelPo uocOrderRelPo = new UocOrderRelPo();
        uocOrderRelPo.setId(IdUtil.nextId());
        uocOrderRelPo.setOrderId(saleOrderDo.getOrderId());
        uocOrderRelPo.setObjId(saleOrderDo.getSaleOrderId());
        uocOrderRelPo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderRelPo.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        uocOrderRelPo.setRelType(UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        this.uocOrderRelMapper.insert(uocOrderRelPo);
    }

    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderPo where = new UocSaleOrderPo();
        where.setOrderId(uocSaleOrderDo.getOrderId());
        where.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        this.uocSaleOrderMapper.updateBy((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class), where);
    }

    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo saleOrderDo) {
        UocSaleOrderPo updateSaleSetPo = new UocSaleOrderPo();
        updateSaleSetPo.setSaleOrderState(saleOrderDo.getSaleOrderState());
        updateSaleSetPo.setUpdateTime(new Date());
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getProcState())) {
            updateSaleSetPo.setProcState(saleOrderDo.getSaleOrderState());
        }
        updateSaleSetPo.setClosePennyDiff(saleOrderDo.getClosePennyDiff());
        updateSaleSetPo.setCancelReason(saleOrderDo.getCancelReason());
        updateSaleSetPo.setCancelReasonFlag(saleOrderDo.getCancelReasonFlag());
        UocSaleOrderPo updateSaleWherePo = new UocSaleOrderPo();
        updateSaleWherePo.setOrderId(saleOrderDo.getOrderId());
        updateSaleWherePo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        this.uocSaleOrderMapper.updateBy(updateSaleSetPo, updateSaleWherePo);
        return saleOrderDo;
    }

    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        UocSaleOrderPo qryPo = (UocSaleOrderPo)UocRu.js((Object)qryDo, UocSaleOrderPo.class);
        UocSaleStakeholderPo qryStakeholderPo = new UocSaleStakeholderPo();
        qryStakeholderPo.setOrderId(qryDo.getOrderId());
        List<UocSaleStakeholderPo> list = this.uocSaleStakeholderMapper.getList(qryStakeholderPo);
        Map<Object, Object> stakeholderMap = new HashMap();
        if (ObjectUtil.isNotEmpty(list)) {
            stakeholderMap = list.stream().collect(Collectors.groupingBy(UocSaleStakeholderPo::getStakeholderId));
        }
        List<UocSaleOrderPo> uocSaleOrderPoList = this.uocSaleOrderMapper.getList(qryPo);
        List<Object> retList = new ArrayList<UocSaleOrderDo>();
        if (ObjectUtil.isNotEmpty(uocSaleOrderPoList)) {
            retList = UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
            for (UocSaleOrderDo uocSaleOrderDo : retList) {
                if (!ObjectUtil.isNotEmpty(stakeholderMap) || !stakeholderMap.containsKey(uocSaleOrderDo.getStakeholderId())) continue;
                uocSaleOrderDo.setStakeholder((UocSaleStakeholder)UocRu.js(((List)stakeholderMap.get(uocSaleOrderDo.getStakeholderId())).get(0), UocSaleStakeholder.class));
            }
        }
        return retList;
    }

    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderDo rspDo = new UocSaleOrderDo();
        UocSaleOrderPo uocSaleOrderPo = this.uocSaleOrderMapper.getModelBy((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class));
        if (ObjectUtil.isNotNull((Object)uocSaleOrderPo)) {
            rspDo = (UocSaleOrderDo)UocRu.js((Object)uocSaleOrderPo, UocSaleOrderDo.class);
        }
        return rspDo;
    }

    private void saveSaleItems(UocSaleOrderDo saleOrderDo) {
        List saleOrderItems = saleOrderDo.getSaleOrderItems();
        ArrayList<UocSaleItemMapPo> itemMapList = new ArrayList<UocSaleItemMapPo>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (ObjectUtil.isNotEmpty((Object)saleOrderItem.getSaleItemMapList())) {
                itemMapList.addAll(UocRu.jsl((List)saleOrderItem.getSaleItemMapList(), UocSaleItemMapPo.class));
            }
            if ("null".equals(saleOrderItem.getSkuMaterialCode())) {
                saleOrderItem.setSkuMaterialCode("");
            }
            if ("null".equals(saleOrderItem.getSkuMaterialId())) {
                saleOrderItem.setSkuMaterialId("");
            }
            if ("null".equals(saleOrderItem.getSkuMaterialTypeId())) {
                saleOrderItem.setSkuMaterialTypeId("");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getCmpOrderNo())) {
                saleOrderItem.setCmpOrderNo(null);
            }
            if (ObjectUtil.isNotEmpty((Object)saleOrderItem.getAttachBos())) {
                this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl((List)saleOrderItem.getAttachBos(), UocOrderAccessoryPo.class));
            }
            if (!ObjectUtil.isNotEmpty((Object)saleOrderItem.getOrderPlanBOList())) continue;
            for (UocOrderPlanBO planBO : saleOrderItem.getOrderPlanBOList()) {
                UocSaleOrderItemPlanPO uocSaleOrderItemPlanPO = new UocSaleOrderItemPlanPO();
                uocSaleOrderItemPlanPO.setSaleOrderId(saleOrderItem.getSaleOrderId());
                uocSaleOrderItemPlanPO.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                uocSaleOrderItemPlanPO.setPlanItemId(planBO.getPlanItemId());
                uocSaleOrderItemPlanPO.setPlanItemNo(planBO.getPlanItemNo());
                uocSaleOrderItemPlanPO.setPlanId(planBO.getPlanId());
                uocSaleOrderItemPlanPO.setPlanNo(planBO.getPlanNo());
                uocSaleOrderItemPlanPO.setId(IdUtil.nextId());
                uocSaleOrderItemPlanPO.setPurchaseCount(planBO.getPurchaseCount());
                this.uocSaleOrderItemPlanMapper.insertSelective(uocSaleOrderItemPlanPO);
            }
        }
        this.uocSaleOrderItemMapper.insertBatch(UocRu.jsl((List)saleOrderItems, UocSaleOrderItemPo.class));
        if (ObjectUtil.isNotEmpty(itemMapList)) {
            this.uocSaleItemMapMapper.insertBatch(itemMapList);
        }
    }

    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo queryUocSaleOrderPo = new UocSaleOrderPo();
        BeanUtils.copyProperties((Object)uocSaleOrderQryBo, (Object)queryUocSaleOrderPo);
        UocSaleOrderPo querySaleOrderResultPo = this.uocSaleOrderMapper.getModelBy(queryUocSaleOrderPo);
        if (null != querySaleOrderResultPo) {
            UocSaleOrderDo returnSaleOrderResultPo = new UocSaleOrderDo();
            BeanUtils.copyProperties((Object)querySaleOrderResultPo, (Object)returnSaleOrderResultPo);
            UocSaleStakeholderPo qryStakeholderPo = new UocSaleStakeholderPo();
            qryStakeholderPo.setOrderId(querySaleOrderResultPo.getOrderId());
            qryStakeholderPo.setStakeholderId(querySaleOrderResultPo.getStakeholderId());
            qryStakeholderPo.setDataAchiveTabSuffix(uocSaleOrderQryBo.getDataAchiveTabSuffix());
            UocSaleStakeholderPo querySaleStakeholderResultPo = this.uocSaleStakeholderMapper.getModelBy(qryStakeholderPo);
            if (null != querySaleStakeholderResultPo) {
                UocSaleStakeholder returnUocSaleStakeholder = new UocSaleStakeholder();
                BeanUtils.copyProperties((Object)querySaleStakeholderResultPo, (Object)returnUocSaleStakeholder);
                returnSaleOrderResultPo.setStakeholder(returnUocSaleStakeholder);
            }
            UocSaleOrderMapPo saleOrderMapPo = new UocSaleOrderMapPo();
            saleOrderMapPo.setOrderId(querySaleOrderResultPo.getOrderId());
            saleOrderMapPo.setSaleOrderId(querySaleOrderResultPo.getSaleOrderId());
            saleOrderMapPo.setDataAchiveTabSuffix(uocSaleOrderQryBo.getDataAchiveTabSuffix());
            List<UocSaleOrderMapPo> saleOrderMapPos = this.uocSaleOrderMapMapper.getList(saleOrderMapPo);
            if (!CollectionUtils.isEmpty(saleOrderMapPos)) {
                ArrayList<Object> saleOrderMaps = new ArrayList<Object>(saleOrderMapPos.size());
                for (UocSaleOrderMapPo orderMapPo : saleOrderMapPos) {
                    saleOrderMaps.add(UocRu.js((Object)orderMapPo, UocSaleOrderMap.class));
                }
                returnSaleOrderResultPo.setSaleOrderMapList(saleOrderMaps);
            }
            return returnSaleOrderResultPo;
        }
        return null;
    }

    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        List<UocOrderAccessoryPo> uocOrderAccessoryPoList = this.uocOrderAccessoryMapper.getList((UocOrderAccessoryPo)UocRu.js((Object)uocOrderAccessoryQryBo, UocOrderAccessoryPo.class));
        if (ObjectUtil.isNotEmpty(uocOrderAccessoryPoList)) {
            uocSaleOrderDo.setSaleOrderAccessoryList(UocRu.jsl(uocOrderAccessoryPoList, UocOrderAccessory.class));
        }
        return uocSaleOrderDo;
    }

    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        List<UocSaleOrderPayConfPo> payConfPoList = this.uocSaleOrderPayConfMapper.getList((UocSaleOrderPayConfPo)UocRu.js((Object)uocSaleOrderPayConfQryBo, UocSaleOrderPayConfPo.class));
        return ObjectUtil.isNotEmpty(payConfPoList) ? UocRu.jsl(payConfPoList, UocSaleOrderPayConf.class) : new ArrayList();
    }

    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        List<UocSaleOrderMapPo> uocSaleOrderMapPoList = this.uocSaleOrderMapMapper.getList((UocSaleOrderMapPo)UocRu.js((Object)uocSaleOrderMapQryBo, UocSaleOrderMapPo.class));
        return ObjectUtil.isNotEmpty(uocSaleOrderMapPoList) ? UocRu.jsl(uocSaleOrderMapPoList, UocSaleOrderMap.class) : new ArrayList();
    }

    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = this.uocSaleOrderItemMapper.getList((UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        List<Object> uocSaleOrderItemList = new ArrayList<UocSaleOrderItem>();
        if (ObjectUtil.isNotEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderItemList = UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class);
        }
        return uocSaleOrderItemList;
    }

    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = this.uocSaleOrderItemMapper.getListByItemIds(itemIds);
        List<Object> uocSaleOrderItemList = new ArrayList<UocSaleOrderItem>();
        if (!CollectionUtils.isEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderItemList = UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class);
        }
        return uocSaleOrderItemList;
    }

    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        List<UocSaleItemMapPo> uocSaleItemMapPoList = this.uocSaleItemMapMapper.getList((UocSaleItemMapPo)UocRu.js((Object)uocSaleItemMapQryBo, UocSaleItemMapPo.class));
        return ObjectUtil.isNotEmpty(uocSaleItemMapPoList) ? UocRu.jsl(uocSaleItemMapPoList, UocSaleItemMap.class) : new ArrayList();
    }

    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = this.uocSaleOrderItemMapper.getList((UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        if (ObjectUtil.isNotEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderDo.setSaleOrderItems(UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class));
        }
        return uocSaleOrderDo;
    }

    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        List<UocSaleStakeholderPo> list = this.uocSaleStakeholderMapper.getList((UocSaleStakeholderPo)UocRu.js((Object)qryBo, UocSaleStakeholderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocSaleStakeholder.class) : new ArrayList();
    }

    public UocSaleStakeholder getSaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        UocSaleStakeholderPo queryUocSaleStakeholderPo = new UocSaleStakeholderPo();
        BeanUtils.copyProperties((Object)qryBo, (Object)queryUocSaleStakeholderPo);
        UocSaleStakeholderPo uocSaleStakeholderResultPo = this.uocSaleStakeholderMapper.getModelBy(queryUocSaleStakeholderPo);
        if (null != uocSaleStakeholderResultPo) {
            UocSaleStakeholder uocSaleStakeholder = new UocSaleStakeholder();
            BeanUtils.copyProperties((Object)uocSaleStakeholderResultPo, (Object)uocSaleStakeholder);
            return uocSaleStakeholder;
        }
        return null;
    }

    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty((Collection)uocSaleOrderDo.getSaleOrderMapList())) {
            this.uocSaleOrderMapMapper.insertBatch(UocRu.jsl((List)uocSaleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class));
        }
    }

    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty((Collection)uocSaleOrderDo.getSaleOrderMapList())) {
            this.uocSaleOrderMapMapper.updateBatchValue(UocRu.jsl((List)uocSaleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class), (UocSaleOrderMapPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderMapPo.class));
        }
    }

    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            this.uocSaleOrderMapMapper.updateInvalid((UocSaleOrderMapPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderMapPo.class));
        }
    }

    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = this.uocSaleOrderMapper.qryTotalFeeAndCount((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderQryBo, UocSaleOrderPo.class));
        return (UocSaleOrderDo)UocRu.js((Object)uocSaleOrderPo, UocSaleOrderDo.class);
    }

    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            this.uocSaleOrderItemMapper.updateBatchItemInspCount(UocRu.jsl((List)uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class));
        }
    }

    public void deleteSaleOrder(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            UocSaleOrderPo where = new UocSaleOrderPo();
            where.setOrderId(uocSaleOrderDo.getOrderId());
            where.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            UocSaleOrderPo set = (UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class);
            set.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
            this.uocSaleOrderMapper.updateBy(set, where);
        }
    }

    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleStakeholderPo where = new UocSaleStakeholderPo();
        where.setOrderId(uocSaleOrderDo.getStakeholder().getOrderId());
        where.setStakeholderId(uocSaleOrderDo.getStakeholder().getStakeholderId());
        UocSaleStakeholderPo set = (UocSaleStakeholderPo)UocRu.js((Object)uocSaleOrderDo.getStakeholder(), UocSaleStakeholderPo.class);
        this.uocSaleStakeholderMapper.updateBy(set, where);
    }

    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        this.uocSaleOrderItemMapper.updateItemReturningCount(uocSaleOrderItem);
    }

    public void modifyBatchItemSalePrice(UocSaleOrderDo uocSaleOrderDo) {
        List uocSaleOrderItemPos = UocRu.jsl((List)uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class);
        this.uocSaleOrderItemMapper.modifyBatchItemSalePrice(uocSaleOrderItemPos, (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class));
    }

    public UocSaleOrderDo getSaleItemTotalPrice(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderPo uocSaleOrderPo = (UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class);
        UocSaleOrderPo po = this.uocSaleOrderItemMapper.getSaleItemTotalPrice(uocSaleOrderPo);
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setTotalSaleFee(po.getTotalSaleFee());
        uocSaleOrderDo1.setTotalPurchaseFee(po.getTotalPurchaseFee());
        return uocSaleOrderDo1;
    }

    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class);
        this.uocSaleOrderItemMapper.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderItemPo);
    }

    public void batchModifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class);
        uocSaleOrderItemPo.setSaleOrderItemIdList(uocSaleOrderDo.getSaleOrderItemsIdList());
        this.uocSaleOrderItemMapper.batchModifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderItemPo);
    }

    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null != convertSaleOrderDo) {
            this.uocSaleOrderItemMapper.updateItemReturnCountZero((UocSaleOrderItem)UocRu.js((Object)convertSaleOrderDo, UocSaleOrderItem.class));
        }
    }

    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null != convertSaleOrderDo) {
            this.uocSaleOrderItemMapper.updateItemReturnCountByChngingCount((UocSaleOrderItem)UocRu.js((Object)convertSaleOrderDo, UocSaleOrderItem.class));
        }
    }

    public void modifyBatchItemChngingCount(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderItemMapper.updateBatchItemChngingCount(UocRu.jsl((List)saleOrderDo.getSaleOrderItems(), UocSaleOrderItem.class), (UocSaleOrderItem)UocRu.js((Object)saleOrderDo, UocSaleOrderItem.class));
    }

    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo qryBo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPos = this.uocSaleOrderItemMapper.getList((UocSaleOrderItemPo)UocRu.js((Object)qryBo, UocSaleOrderItemPo.class));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderItems(UocRu.jsl(uocSaleOrderItemPos, UocSaleOrderItem.class));
        return uocSaleOrderDo;
    }

    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        if (!CollectionUtils.isEmpty((Collection)convertSaleOrderDo.getSaleOrderItems())) {
            this.uocSaleOrderItemMapper.updateBatchItemSendCount(UocRu.jsl((List)convertSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), (UocSaleOrderItemPo)UocRu.js((Object)convertSaleOrderDo, UocSaleOrderItemPo.class));
        }
    }

    public void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo) {
        if (!CollectionUtils.isEmpty((Collection)convertSaleOrderDo.getSaleOrderItems())) {
            this.uocSaleOrderItemMapper.updateBatchItemArrivalTime(UocRu.jsl((List)convertSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), (UocSaleOrderItemPo)UocRu.js((Object)convertSaleOrderDo, UocSaleOrderItemPo.class));
        }
    }

    public UocSaleOrderDo getCollectCount(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = this.uocSaleOrderItemMapper.getCollectCount((UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)UocRu.js((Object)uocSaleOrderItemPo, UocSaleOrderItem.class);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderItems(Collections.singletonList(uocSaleOrderItem));
        return uocSaleOrderDo;
    }

    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        this.uocSaleOrderItemMapper.updateSaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = new UocSaleOrderItemPo();
        uocSaleOrderItemPo.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderItemPo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        this.uocSaleOrderItemMapper.modifyInspSuper(uocSaleOrderItemPo);
    }

    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemRefuseCountConfirm((UocSaleOrderItem)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItem.class));
    }

    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemArriveCountConfirm((UocSaleOrderItem)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItem.class));
    }

    public int updateItem(UocSaleOrderDo uocSaleOrderDo) {
        int updated = 0;
        List saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocSaleOrderItemPo set = new UocSaleOrderItemPo();
            UocSaleOrderItemPo where = new UocSaleOrderItemPo();
            set.setNakedPrice(saleOrderItem.getNakedPrice());
            set.setTax(saleOrderItem.getTax());
            set.setTaxPrice(saleOrderItem.getTaxPrice());
            where.setOrderId(saleOrderItem.getOrderId());
            where.setSaleOrderId(saleOrderItem.getSaleOrderId());
            where.setSkuExtSkuId(saleOrderItem.getSkuExtSkuId());
            int i = this.uocSaleOrderItemMapper.updateBy(set, where);
            if (i != 1) continue;
            ++updated;
        }
        return updated;
    }

    public void updateItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        List saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocSaleOrderItemPo set = new UocSaleOrderItemPo();
            UocSaleOrderItemPo where = new UocSaleOrderItemPo();
            set.setArriveCount(saleOrderItem.getArriveCount());
            set.setRefuseCount(saleOrderItem.getRefuseCount());
            where.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            int n = this.uocSaleOrderItemMapper.updateAccount(set, where);
        }
    }

    public void modifyBatchItemPurchasePrice(UocSaleOrderDo uocSaleOrderDo) {
        List uocSaleOrderItemPos = UocRu.jsl((List)uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class);
        this.uocSaleOrderItemMapper.modifyBatchItemPurchasePrice(uocSaleOrderItemPos, (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class));
    }

    public void modifyItemChngCountRefuse(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemChngCountRefuse((UocSaleOrderItem)UocRu.js((Object)saleOrderDo, UocSaleOrderItem.class));
    }

    public void modifyItemChngCountConfirm(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemChngCountConfirm((UocSaleOrderItem)UocRu.js((Object)saleOrderDo, UocSaleOrderItem.class));
    }

    public void modifyItemChngCountConfirmAdd(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemChngCountConfirmAdd((UocSaleOrderItem)UocRu.js((Object)saleOrderDo, UocSaleOrderItem.class));
    }

    public void modifyItemChngCountConfirmReduce(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemChngCountConfirmReduce((UocSaleOrderItem)UocRu.js((Object)saleOrderDo, UocSaleOrderItem.class));
    }

    public List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = (UocSaleOrderPo)UocRu.js((Object)uocSaleOrderQryBo, UocSaleOrderPo.class);
        List<UocSaleOrderPo> uocSaleOrderPoList = this.uocSaleOrderMapper.getList(uocSaleOrderPo);
        log.info("\u9500\u552e\u5355\u5217\u8868\u67e5\u8be2\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString(uocSaleOrderPoList));
        return UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
    }

    public List<UocSaleOrderDo> cancelEsOrderList(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderPo> uocSaleOrderPoList = this.uocSaleOrderMapper.cancelEsOrderList((UocSaleOrderPo)UocRu.js((Object)saleOrderDo, UocSaleOrderPo.class));
        return UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
    }

    public List<UocSaleOrderDo> getSaleOrders(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = (UocSaleOrderPo)UocRu.js((Object)uocSaleOrderQryBo, UocSaleOrderPo.class);
        List<UocSaleOrderPo> uocSaleOrderPoList = this.uocSaleOrderMapper.getSaleOrders(uocSaleOrderPo);
        return UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
    }

    public int updateSaleOrderPayConfMoney(UocSaleOrderPayConf uocSaleOrderPayConf) {
        UocSaleOrderPayConfPo wherePO = new UocSaleOrderPayConfPo();
        wherePO.setOrderId(uocSaleOrderPayConf.getOrderId());
        wherePO.setSaleOrderId(uocSaleOrderPayConf.getSaleOrderId());
        wherePO.setUserType(uocSaleOrderPayConf.getUserType());
        UocSaleOrderPayConfPo setPO = new UocSaleOrderPayConfPo();
        setPO.setPrePayFee(uocSaleOrderPayConf.getPrePayFee());
        setPO.setVerPayFee(uocSaleOrderPayConf.getVerPayFee());
        setPO.setPilPayFee(uocSaleOrderPayConf.getPilPayFee());
        setPO.setQuaPayFee(uocSaleOrderPayConf.getQuaPayFee());
        return this.uocSaleOrderPayConfMapper.updateBy(setPO, wherePO);
    }

    public int qrySaleOrderCounts(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderPo uocSaleOrderPo = (UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class);
        return this.uocSaleOrderMapper.getCheckBy(uocSaleOrderPo);
    }

    public int insertCommityAfterTakeType(UocSaleGoodsAfterTakeTypeBo afterTakeTypeBo) {
        UocSaleAfterTakeTypePo afterTakeTypePo = (UocSaleAfterTakeTypePo)UocRu.js((Object)afterTakeTypeBo, UocSaleAfterTakeTypePo.class);
        return this.uocSaleAfterTakeTypeMapper.insert(afterTakeTypePo);
    }

    public List<UocSaleGoodsAfterTakeTypeBo> qryCommityTakeTypes(UocSaleGoodsAfterTakeTypeBo takeTypeBo) {
        UocSaleAfterTakeTypePo afterTakeTypePo = (UocSaleAfterTakeTypePo)UocRu.js((Object)takeTypeBo, UocSaleAfterTakeTypePo.class);
        List<UocSaleAfterTakeTypePo> takeTypePos = this.uocSaleAfterTakeTypeMapper.selectByCondition(afterTakeTypePo);
        return UocRu.jsl(takeTypePos, UocSaleGoodsAfterTakeTypeBo.class);
    }

    public List<UocSaleOrderItemPlan> selectSaleOrderItemPlan(UocSaleOrderItemPlanBo record) {
        List<UocSaleOrderItemPlanPO> uocSaleOrderItemPlanPOS = this.uocSaleOrderItemPlanMapper.selectByCondition((UocSaleOrderItemPlanPO)UocRu.js((Object)record, UocSaleOrderItemPlanPO.class));
        return UocRu.jsl(uocSaleOrderItemPlanPOS, UocSaleOrderItemPlan.class);
    }

    public List<UocSaleOrderDo> getSaleOrderListByBar(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return UocRu.jsl(this.uocSaleOrderMapper.getSaleOrderListByBar((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderQryBo, UocSaleOrderPo.class)), UocSaleOrderDo.class);
    }

    public void batchSyncSale() {
        int pageSize = this.uocPropertiesConfig.getSyncEsPageSize();
        Page page = new Page(this.uocPropertiesConfig.getSyncEsPageStart().intValue(), pageSize);
        List<UocSaleOrderPo> listPage = this.uocSaleOrderMapper.getSaleAndOrderIdListByPage(new UocSaleOrderPo(), (Page<UocSaleOrderPo>)page);
        this.syncSaleEs(listPage);
        for (int i = 2; i <= page.getTotalPages(); ++i) {
            Page pageInner = new Page(i, pageSize);
            List<UocSaleOrderPo> innerList = this.uocSaleOrderMapper.getSaleAndOrderIdListByPage(new UocSaleOrderPo(), (Page<UocSaleOrderPo>)pageInner);
            this.syncSaleEs(innerList);
        }
    }

    public void modifyItemPlan(UocSaleOrderItem saleOrderItem) {
        this.uocSaleOrderItemMapper.modifyItemPlan(saleOrderItem);
    }

    public void insertSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo) {
        this.sapOrderSendInfoMapper.insert((SapOrderSendInfoPO)UocRu.js((Object)uocSapOrderSendInfo, SapOrderSendInfoPO.class));
    }

    public void updateSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo) {
        this.sapOrderSendInfoMapper.update((SapOrderSendInfoPO)UocRu.js((Object)uocSapOrderSendInfo, SapOrderSendInfoPO.class));
    }

    public List<UocSapOrderSendInfo> getSapSendInfoList(UocSapOrderSendInfo uocSapOrderSendInfo) {
        List<SapOrderSendInfoPO> result = this.sapOrderSendInfoMapper.selectByCondition((SapOrderSendInfoPO)UocRu.js((Object)uocSapOrderSendInfo, SapOrderSendInfoPO.class));
        if (CollectionUtils.isEmpty(result)) {
            return new ArrayList<UocSapOrderSendInfo>();
        }
        return UocRu.jsl(result, UocSapOrderSendInfo.class);
    }

    public BasePageRspBo<UocSapSendOrderLog> getSapSendInfoListPage(UocQrySapSendOrderLogReqBO uocQrySapSendOrderLogReqBO) {
        Page page = new Page(uocQrySapSendOrderLogReqBO.getPageNo(), uocQrySapSendOrderLogReqBO.getPageSize());
        List<SapOrderSendInfoPO> uocSapOrderSendInfoList = this.sapOrderSendInfoMapper.selectByConditionPage((SapOrderSendInfoPO)UocRu.js((Object)uocQrySapSendOrderLogReqBO, SapOrderSendInfoPO.class), (Page<SapOrderSendInfoPO>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UocRu.jsl(uocSapOrderSendInfoList, UocSapSendOrderLog.class));
        return rspBo;
    }

    public int insertSapArrivalInspBatch(List<UocSapArrivalInspInfo> list) {
        return this.sapArrivalInspInfoMapper.insertBatch(UocRu.jsl(list, SapArrivalInspInfoPO.class));
    }

    public List<UocInspOrderTemporarily> selectTempInspOrderList(UocInspOrderTemporarily uocInspOrderTemporarily) {
        List<UocInspOrderTemporarilyPO> result = this.uocInspOrderTemporarilyMapper.selectByCondition((UocInspOrderTemporarilyPO)UocRu.js((Object)uocInspOrderTemporarily, UocInspOrderTemporarilyPO.class));
        if (!CollectionUtils.isEmpty(result)) {
            return UocRu.jsl(result, UocInspOrderTemporarily.class);
        }
        return new ArrayList<UocInspOrderTemporarily>();
    }

    public BasePageRspBo<UocInspOrderTemporarily> selectTempInspOrderListPage(UocQryTempInspListReqBO uocQryTempInspListReqBO) {
        BasePageRspBo rspBo = new BasePageRspBo();
        Page page = new Page();
        List<UocInspOrderTemporarilyPO> result = this.uocInspOrderTemporarilyMapper.getListPage((UocInspOrderTemporarilyPO)UocRu.js((Object)uocQryTempInspListReqBO, UocInspOrderTemporarilyPO.class), (Page<UocInspOrderTemporarilyPO>)page);
        rspBo.setRows(UocRu.jsl(result, UocInspOrderTemporarily.class));
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        return rspBo;
    }

    public void updateTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily) {
        UocInspOrderTemporarilyPO setPO = new UocInspOrderTemporarilyPO();
        BeanUtils.copyProperties((Object)uocInspOrderTemporarily, (Object)setPO);
        this.uocInspOrderTemporarilyMapper.update(setPO);
    }

    public void insertTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily) {
        this.uocInspOrderTemporarilyMapper.insert((UocInspOrderTemporarilyPO)UocRu.js((Object)uocInspOrderTemporarily, UocInspOrderTemporarilyPO.class));
    }

    public List<UocInspOrderItemTemporarily> selectTempInspOrderItemList(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        List<UocInspOrderItemTemporarilyPO> result = this.uocInspOrderItemTemporarilyMapper.getList((UocInspOrderItemTemporarilyPO)UocRu.js((Object)uocInspOrderItemTemporarily, UocInspOrderItemTemporarilyPO.class));
        if (!CollectionUtils.isEmpty(result)) {
            return UocRu.jsl(result, UocInspOrderItemTemporarily.class);
        }
        return new ArrayList<UocInspOrderItemTemporarily>();
    }

    public void updateTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        UocInspOrderItemTemporarilyPO wherePO = new UocInspOrderItemTemporarilyPO();
        wherePO.setTempInspOrderId(uocInspOrderItemTemporarily.getTempInspOrderId());
        wherePO.setSaleOrderId(uocInspOrderItemTemporarily.getSaleOrderId());
        wherePO.setOrderId(uocInspOrderItemTemporarily.getOrderId());
        UocInspOrderItemTemporarilyPO setPO = new UocInspOrderItemTemporarilyPO();
        BeanUtils.copyProperties((Object)uocInspOrderItemTemporarily, (Object)setPO);
        this.uocInspOrderItemTemporarilyMapper.updateBy(setPO, wherePO);
    }

    public void insertTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily) {
        this.uocInspOrderItemTemporarilyMapper.insert((UocInspOrderItemTemporarilyPO)UocRu.js((Object)uocInspOrderItemTemporarily, UocInspOrderItemTemporarilyPO.class));
    }

    private void syncSaleEs(List<UocSaleOrderPo> listPage) {
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        for (UocSaleOrderPo uocSaleOrderPo : listPage) {
            SyncEsRunnableBo signleSync = new SyncEsRunnableBo();
            signleSync.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            signleSync.setOrderId(uocSaleOrderPo.getOrderId());
            signleSync.setObjId(uocSaleOrderPo.getSaleOrderId());
            signleSync.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            syncEsRunnableBoList.add(signleSync);
        }
        this.uocThreadPool.executeRunnable((Runnable)new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

