package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.math.BigDecimal;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: SapArrivalInspInfoPO
 * @Description: SapArrivalInspInfoPO
 * @author: Luokan
 * @date: 2024年07月04日14:16:51
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class SapArrivalInspInfoPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * sap收货信息id
	 */
    private Long inspInfoId;
	/**
	 * sap订单编号
	 */
    private String sapOrderNo;
	/**
	 * sap订单明细编号
	 */
    private String sapOrderItemNo;
	/**
	 * 计划验收数量
	 */
    private BigDecimal planInspCount;
	/**
	 * 验收数量
	 */
    private BigDecimal inspCount;
	/**
	 * 验收人名称
	 */
    private String inspOperName;
	/**
	 * 0：未处理 1：已处理
	 */
    private Integer status;
	/**
	 * 物料凭证编号
	 */
    private String sapVoucherNo;
	/**
	 * 物料凭证中的项目
	 */
    private String sapVoucherItemNo;
	/**
	 * 物料编码
	 */
    private String materialCode;
	/**
	 * 验收日期
	 */
    private String inspTime;
	/**
	 * 验收备注
	 */
    private String inspRemark;
	/**
	 * 能力平台能力名
	 */
    private String platformName;
	/**
	 * 能力平台流水号
	 */
    private String platformNo;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 更新时间
	 */
    private Date updateTime;

}