package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemMap;
import com.tydic.dyc.oc.repository.po.UocChngOrderItemMapPo;
import com.tydic.dyc.oc.repository.po.UocChngOrderItemObjPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocChngOrderItemObjMapper
 * 说明:变更单明细对
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocChngOrderItemObjMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocChngOrderItemObjPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocChngOrderItemObjPo uocChngOrderItemObjPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocChngOrderItemObjPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocChngOrderItemObjPo uocChngOrderItemObjPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocChngOrderItemObjPo set, @Param("where") UocChngOrderItemObjPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocChngOrderItemObjPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocChngOrderItemObjPo uocChngOrderItemObjPo);

	/**
     * 根据条件查询单条数据
     *
     * @param uocChngOrderItemObjPo 参数对象
     * @return UocChngOrderItemObj 结果对象
     */
	UocChngOrderItemObjPo getModelBy(UocChngOrderItemObjPo uocChngOrderItemObjPo);

    /**
     * 根据条件查询列表数据
     *
     * @param uocChngOrderItemObjPo 参数对象
     * @return List<UocChngOrderItemObj> 结果对象
	 */
	List<UocChngOrderItemObjPo> getList(UocChngOrderItemObjPo uocChngOrderItemObjPo);

    /**
     * 根据条件分页查询列表数据
     *
     * @param uocChngOrderItemObjPo 参数对象
     * @param page 分页参数
     * @return List<UocChngOrderItemObj> 结果对象
	 */
	List<UocChngOrderItemObjPo> getListPage(UocChngOrderItemObjPo uocChngOrderItemObjPo, Page<UocChngOrderItemObjPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocChngOrderItemObjPo> list);

	/**
	 * 批量插入数据拓展明细信息
	 */
	void insertItemMapBatch(List<UocChngOrderItemMapPo> list);

	/**
	 * 查询变更明细拓展明细信息
	 * @param uocChngOrderItemMapPo
	 * @return
	 */
	List<UocChngOrderItemMapPo> getChngItemMapItem(UocChngOrderItemMapPo uocChngOrderItemMapPo);

	/**
	 * 批量插入数据拓展明细信息
	 */
	void modifyItemChngCountConfirm(UocChngOrderItemObjPo po);
}
