package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocImplOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocImplOrderItemMapper
 * 说明:执行单明细
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocImplOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocImplOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocImplOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocImplOrderItemPo set, @Param("where") UocImplOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocImplOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocImplOrderItemPo 参数对象
	 * @return UocImplOrderItemPo 结果对象
	 */
	UocImplOrderItemPo getModelBy(UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocImplOrderItemPo 参数对象
	 * @return List<UocImplOrderItemPo> 结果对象
	 */
	List<UocImplOrderItemPo> getList(UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocImplOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocImplOrderItemPo> 结果对象
	 */
	List<UocImplOrderItemPo> getListPage(UocImplOrderItemPo uocImplOrderItemPo, Page<UocImplOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocImplOrderItemPo> list);

	/**
	 * 批量更新发货数量
	 *
	 * @param list 参数列表
	 */
	void updateBatchItemSendCount(@Param("list") List<UocImplOrderItemPo> list, @Param("uocImplOrderItemPo") UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 批量更新到货数量
	 */
	void updateItemArriveCount(@Param("list") List<UocImplOrderItemPo> list, @Param("uocImplOrderItemPo") UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 批量更新拒收数量
	 */
	void updateItemRefuseCount(@Param("list") List<UocImplOrderItemPo> list, @Param("uocImplOrderItemPo") UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 批量更新验收数量
	 */
	void updateBatchItemInspCount(@Param("list") List<UocImplOrderItemPo> list, @Param("uocImplOrderItemPo") UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 批量更新异常变更在途数量
	 */
	void updateBatchItemChngingCount(@Param("list") List<UocImplOrderItemPo> list, @Param("uocImplOrderItemPo") UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 批量更新退货数量 依据异常变更在途数量更新
	 */
	void updateBatchItemReturnCountByChngCount(UocImplOrderItemPo uocImplOrderItemPo);

	/**
	 * 查询执行明细数量汇总
	 */
	UocImplOrderItemPo getCollectCount(UocImplOrderItemPo uocImplOrderItemPo);

    void updateBatchItemChngCountZero(UocImplOrderItemPo uocImplOrderItemPo);
}
