package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.*;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.repository.UocCmpOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocCmpItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocCmpOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocCmpOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocCmpOrderMapper;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.service.cmporder.bo.UocQryCmpOrderDetailServiceItemBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocCmpOrderRepositoryImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/29 11:33
 * 作者 @author 尹栋梁
 */
@Service
public class UocCmpOrderRepositoryImpl implements UocCmpOrderRepository {

    @Autowired
    private UocCmpOrderMapper uocCmpOrderMapper;
    @Autowired
    private UocCmpOrderMapMapper uocCmpOrderMapMapper;

    @Autowired
    private UocCmpOrderItemMapper uocCmpOrderItemMapper;

    @Autowired
    private UocCmpItemMapMapper uocCmpItemMapMapper;

    @Override
    public void createCmpOrder(UocCmpOrderDo uocCmpOrderDo) {
        uocCmpOrderMapper.insert(UocRu.js(uocCmpOrderDo, UocCmpOrderPo.class));
        if (CollectionUtil.isNotEmpty(uocCmpOrderDo.getUocCmpOrderItemList())) {
            uocCmpOrderItemMapper.insertBatch(UocRu.jsl(uocCmpOrderDo.getUocCmpOrderItemList(), UocCmpOrderItemPo.class));
            List<UocCmpItemMapPo> uocCmpItemMapPoList = new ArrayList<>();
            for (UocCmpOrderItem uocCmpOrderItem : uocCmpOrderDo.getUocCmpOrderItemList()) {
                if(!CollectionUtils.isEmpty(uocCmpOrderItem.getUocCmpItemMapList())){
                    uocCmpItemMapPoList.addAll(UocRu.jsl(uocCmpOrderItem.getUocCmpItemMapList(), UocCmpItemMapPo.class));
                }
            }
            if(!CollectionUtils.isEmpty(uocCmpItemMapPoList)){
                uocCmpItemMapMapper.insertBatch(uocCmpItemMapPoList);
            }
        }
        if(!CollectionUtils.isEmpty(uocCmpOrderDo.getUocCmpOrderMapList())){
            uocCmpOrderMapMapper.insertBatch(UocRu.jsl(uocCmpOrderDo.getUocCmpOrderMapList(), UocCmpOrderMapPo.class));
        }
    }

    @Override
    public UocCmpOrderQryBo qryCmpOrder(UocCmpOrderQryBo uocCmpOrderDo) {
        UocCmpOrderQryBo result = new UocCmpOrderQryBo();
        UocCmpOrderPo uocCmpOrderPo = new UocCmpOrderPo();
        uocCmpOrderPo.setCmpOrderNo(uocCmpOrderDo.getCmpOrderNo());
        UocCmpOrderPo cmpOrderPo = uocCmpOrderMapper.getModelBy(uocCmpOrderPo);
        if (ObjectUtil.isEmpty(cmpOrderPo)) {
            return result;
        }
        result = UocRu.js(cmpOrderPo, UocCmpOrderQryBo.class);
        UocCmpOrderMapPo uocCmpOrderMapPo = new UocCmpOrderMapPo();
        uocCmpOrderMapPo.setCmpOrderId(cmpOrderPo.getCmpOrderId());
        uocCmpOrderMapPo.setOrderId(cmpOrderPo.getOrderId());
        List<UocCmpOrderMapPo> uocCmpOrderMapPoList = uocCmpOrderMapMapper.getList(uocCmpOrderMapPo);
        result.setUocCmpOrderMapList(UocRu.jsl(uocCmpOrderMapPoList, UocCmpOrderMapQryBo.class));
        UocCmpOrderItemPo uocCmpOrderItemPo = new UocCmpOrderItemPo();
        uocCmpOrderItemPo.setCmpOrderId(cmpOrderPo.getCmpOrderId());
        uocCmpOrderItemPo.setOrderBy("sku_order asc");
        List<UocCmpOrderItemPo> cmpOrderItemList = uocCmpOrderItemMapper.getList(uocCmpOrderItemPo);
        if (CollectionUtil.isNotEmpty(cmpOrderItemList)) {
            result.setUocCmpOrderItemList(UocRu.jsl(cmpOrderItemList, UocCmpOrderItemQryBo.class));
            UocCmpItemMapPo uocCmpItemMapPo = new UocCmpItemMapPo();
            uocCmpItemMapPo.setCmpOrderItemIdList(cmpOrderItemList.stream().map(UocCmpOrderItemPo::getCmpOrderItemId).collect(Collectors.toList()));
            uocCmpItemMapPo.setOrderId(cmpOrderPo.getOrderId());
            List<UocCmpItemMapPo> uocCmpItemMapPoList = uocCmpItemMapMapper.getList(uocCmpItemMapPo);
            if(!CollectionUtils.isEmpty(uocCmpItemMapPoList)){
                ConcurrentMap<Long, List<UocCmpItemMapPo>> cmpMap = uocCmpItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocCmpItemMapPo::getCmpOrderItemId));
                for (UocCmpOrderItemQryBo uocCmpOrderItemQryBo : result.getUocCmpOrderItemList()) {
                    List<UocCmpItemMapPo> uocCmpItemMapPos = cmpMap.get(uocCmpOrderItemQryBo.getCmpOrderItemId());
                    uocCmpOrderItemQryBo.setUocCmpItemMapList(UocRu.jsl(uocCmpItemMapPos, UocCmpItemMapQryBo.class));
                }
            }
        }
        return result;
    }

    @Override
    public Integer getCheckBy(UocCmpOrderDo uocCmpOrderDo) {
        return uocCmpOrderMapper.getCheckBy(UocRu.js(uocCmpOrderDo, UocCmpOrderPo.class));
    }

    @Override
    public UocQryCmpOrderNoBo qryCmpOrderNoBySkuIdAndUserId(UocQryCmpOrderNoBo qryBo) {
        return uocCmpOrderMapper.qryCmpOrderNoBySkuIdAndUserId(qryBo);
    }

    @Override
    public int dealCmpOrder(UocDelCmpOrderBo uocDelCmpOrderBo) {
        //删除比选单
        UocCmpOrderPo uocCmpOrderPo = new UocCmpOrderPo();
        uocCmpOrderPo.setCmpOrderId(uocDelCmpOrderBo.getCmpOrderId());
        uocCmpOrderPo.setCmpOrderNo(uocDelCmpOrderBo.getCmpOrderNo());
        int i = uocCmpOrderMapper.updateCmpOrderByCmpOrderId(uocCmpOrderPo);
    
        UocCmpOrderItemPo uocCmpOrderItemPo = new UocCmpOrderItemPo();
    
        uocCmpOrderItemPo.setCmpOrderId(uocDelCmpOrderBo.getCmpOrderId());
        List<UocCmpOrderItemPo> uocCmpOrderItemPos =  uocCmpOrderItemMapper.getList(uocCmpOrderItemPo);
        if (ObjectUtil.isNotEmpty(uocCmpOrderItemPos)){
            for (UocCmpOrderItemPo item:uocCmpOrderItemPos){
                UocDelCmpOrderPo uocDelCmpOrderPo = new UocDelCmpOrderPo();
                uocDelCmpOrderPo.setCmpOrderItemId(item.getCmpOrderItemId());
                uocDelCmpOrderPo.setCmpOrderId(item.getCmpOrderId());
                uocCmpOrderItemMapper.updateCmpItemOrder(uocDelCmpOrderPo);
            }
        }
        return i;
    }

    @Override
    public int updateCmpOrder(UocUpdateCmpOrderBo uocUpdateCmpOrderBo) {
        int i =0;
        //删除比选单明细
        if (ObjectUtil.isNotEmpty(uocUpdateCmpOrderBo.getCmpOrderItemIdDelList())){
            List<UocQryCmpOrderDetailServiceItemBo> cmpOrderItemIdDelList = uocUpdateCmpOrderBo.getCmpOrderItemIdDelList();
            for (UocQryCmpOrderDetailServiceItemBo uocQryCmpOrderDetailServiceItemBo : cmpOrderItemIdDelList) {
                UocDelCmpOrderPo uocDelCmpOrderPo = new UocDelCmpOrderPo();
                uocDelCmpOrderPo.setCmpOrderId(uocUpdateCmpOrderBo.getCmpOrderId());
                uocDelCmpOrderPo.setCmpOrderItemId(uocQryCmpOrderDetailServiceItemBo.getCmpOrderItemId());
                i += uocCmpOrderItemMapper.updateCmpItemOrder(uocDelCmpOrderPo);
            }
        }
        //新增或者更新比选单明细
        if (ObjectUtil.isNotEmpty(uocUpdateCmpOrderBo.getCmpOrderItemAddList())){
            List<UocQryCmpOrderDetailServiceItemBo> cmpOrderItemAddList = uocUpdateCmpOrderBo.getCmpOrderItemAddList();
            for (UocQryCmpOrderDetailServiceItemBo uocQryCmpOrderDetailServiceItemBo : cmpOrderItemAddList) {
    
                UocCmpOrderItemPo uocCmpOrderItemPo = new UocCmpOrderItemPo();
                BeanUtils.copyProperties(uocQryCmpOrderDetailServiceItemBo,uocCmpOrderItemPo);
                uocCmpOrderItemPo.setCmpOrderItemId(IdUtil.nextId());
                uocCmpOrderItemPo.setCmpOrderId(uocUpdateCmpOrderBo.getCmpOrderId());
                uocCmpOrderItemPo.setCreateTime(new Date());
                i += uocCmpOrderItemMapper.insert(uocCmpOrderItemPo);
            }
        }
        return i;
    }

    @Override
    public UocQryCmpOrderNoBo qryAlreadyHaveCmpOrderNo(UocQryCmpOrderNoBo qryBo) {
        return uocCmpOrderMapper.qryAlreadyHaveCmpOrderNo(qryBo);
    }
}
