package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * 描述：寻源操作记录表pro
 * 
 * @author 文乐
 * @date 2023-07-21 18:12
 **/
@Data
public class UocBargainingProgressRecordPO implements Serializable {
	private static final long serialVersionUID =  -8649956520681876592L;

	/**
	 * 操作ID
	 */
	private Long progressRecordId;
	/**
	 * 议价单id
	 */
	private Long bargainingId;
	/**
	 * 操作类型
		1 发起议价,
		2 议价单终止,
		3 供应商已报价,
		4. 重新议价,
		5. 下单成功
	 */
	private Integer operType;
	/**
	 * 操作类型名称
	 */
	private String operTypeName;
	/**
	 * 报价轮次(DYC)
	 */
	private Integer quotationRound;
	/**
	 * 状态
            1：正常
            2：异常
	 */
	private String recordStatus;
	/**
	 * 操作人ID
	 */
	private Long operId;
	/**
	 * 操作人名称
	 */
	private String operName;
	/**
	 * 操作时间
	 */
	private Date operTime;
	private Date operTimeStart;
	private Date operTimeEnd;
	/**
	 * 订单id(用于下单成功 显示备注信息)
	 */
	private Long orderId;
	/**
	 * 扩展字段1
	 */
	private String extField1;
	/**
	 * 扩展字段2
	 */
	private String extField2;
	/**
	 * 扩展字段3
	 */
	private String extField3;
	/**
	 * 扩展字段4
	 */
	private String extField4;
	/**
	 * 扩展字段5
	 */
	private String extField5;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 排序
	 */
	private String orderBy;

}
