package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocApplyOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocApplyOrderItemMapper
 * 说明:申请明细
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocApplyOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocApplyOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocApplyOrderItemPo uocApplyOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocApplyOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocApplyOrderItemPo uocApplyOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocApplyOrderItemPo set, @Param("where") UocApplyOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocApplyOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocApplyOrderItemPo uocApplyOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocApplyOrderItemPo 参数对象
	 * @return UocApplyOrderItemPo 结果对象
	 */
	UocApplyOrderItemPo getModelBy(UocApplyOrderItemPo uocApplyOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocApplyOrderItemPo 参数对象
	 * @return List<UocApplyOrderItemPo> 结果对象
	 */
	List<UocApplyOrderItemPo> getList(UocApplyOrderItemPo uocApplyOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocApplyOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocApplyOrderItemPo> 结果对象
	 */
	List<UocApplyOrderItemPo> getListPage(UocApplyOrderItemPo uocApplyOrderItemPo, Page<UocApplyOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocApplyOrderItemPo> list);

}
