package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBargainingAddressPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：收货地址信息表
 * 
 * @author 文乐
 * @date 2023-07-21 18:11
 **/
@Mapper
@Repository
public interface UocBargainingAddressMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBargainingAddressPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBargainingAddressPO uocBargainingAddressPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBargainingAddressPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBargainingAddressPO uocBargainingAddressPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBargainingAddressPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocBargainingAddressPO uocBargainingAddressPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBargainingAddressPO set, @Param("where") UocBargainingAddressPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBargainingAddressPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBargainingAddressPO uocBargainingAddressPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBargainingAddressPo 参数对象
	 * @return UocBargainingAddressPO 结果对象
	 */
	UocBargainingAddressPO getModelBy(UocBargainingAddressPO uocBargainingAddressPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBargainingAddressPo 参数对象
	 * @return List<UocBargainingAddressPO> 结果对象
	 */
	List<UocBargainingAddressPO> getList(UocBargainingAddressPO uocBargainingAddressPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingAddressPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingAddressPO> 结果对象
	 */
	List<UocBargainingAddressPO> getListPage(UocBargainingAddressPO uocBargainingAddressPo, Page<UocBargainingAddressPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBargainingAddressPO> list);

}
