package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.UocInspTempAfProcessTaskDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import org.aspectj.weaver.ast.Var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocAfOrderRepositoryImpl
 * 说明:售后单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
public class UocAfOrderRepositoryImpl implements UocAfOrderRepository {

    @Autowired
    private UocAfOrderMapper uocAfOrderMapper;
    @Autowired
    private UocAfOrderMapMapper uocAfOrderMapMapper;
    @Autowired
    private UocAfOrderObjMapper uocAfOrderObjMapper;
    @Autowired
    private UocAfOrderItemMapper uocAfOrderItemMapper;
    @Autowired
    private UocAfItemMapMapper uocAfItemMapMapper;
    @Autowired
    private UocAfOrderWaybillMapper uocAfOrderWaybillMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrdLogisticsRelaMapper uocOrdLogisticsRelaMapper;

    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    /**
     * 临时验收售后处理任务表Mapper
     */
    @Autowired
    private UocInspTempAfProcessTaskMapper uocInspTempAfProcessTaskMapper;

    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        List<UocAfOrderItemPo> list = uocAfOrderItemMapper.getList(UocRu.js(uocAfOrderItemQryBo, UocAfOrderItemPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderItem.class) : new ArrayList<>();
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
        uocAfOrderPo.setAfOrderId(uocAfOrderQryBo.getAfOrderId());
        if (ObjectUtil.isNotNull(uocAfOrderQryBo.getOrderId())) {
            uocAfOrderPo.setOrderId(uocAfOrderQryBo.getOrderId());
        }
        uocAfOrderPo.setDataAchiveTabSuffix(uocAfOrderQryBo.getDataAchiveTabSuffix());
        uocAfOrderPo = uocAfOrderMapper.getModelBy(uocAfOrderPo);
        return null != uocAfOrderPo ? UocRu.js(uocAfOrderPo, UocAfOrder.class) : null;
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        List<UocAfOrderPo> list = uocAfOrderMapper.getList(UocRu.js(uocAfOrderQryBo, UocAfOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrder.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        List<UocAfOrderObjPo> list = uocAfOrderObjMapper.getList(UocRu.js(uocAfOrderObjQryBo, UocAfOrderObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        List<UocAfOrderMapPo> list = uocAfOrderMapMapper.getList(UocRu.js(uocAfOrderMapQryBo, UocAfOrderMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderMap.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        List<UocAfOrderWaybillPo> list = uocAfOrderWaybillMapper.getList(UocRu.js(uocAfOrderWaybillQryBo, UocAfOrderWaybillPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderWaybill.class) : new ArrayList<>();
    }

    @Override
    public void modifyAfOrder(UocAfOrderDo uocAfOrderDo) {
        UocAfOrderPo where = new UocAfOrderPo();
        where.setAfOrderId(uocAfOrderDo.getAfOrderId());
        uocAfOrderMapper.updateBy(UocRu.js(uocAfOrderDo, UocAfOrderPo.class), where);
    }

    @Override
    public UocAfOrderDo saveAfterOder(UocAfOrderDo afOrderDo) {
        UocAfOrderPo uocAfOrderPo = UocRu.js(afOrderDo, UocAfOrderPo.class);
        uocAfOrderMapper.insert(uocAfOrderPo);
        List<UocAfOrderMap> extParallelBoList = afOrderDo.getExtParallelBoList();
        if (ObjectUtil.isNotEmpty(extParallelBoList)) {
            uocAfOrderMapMapper.insertBatch(UocRu.jsl(extParallelBoList, UocAfOrderMapPo.class));
        }
        uocAfOrderObjMapper.insertBatch(UocRu.jsl(afOrderDo.getAfOrderObjList(), UocAfOrderObjPo.class));
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        if (ObjectUtil.isNotEmpty(afOrderItemBoList)) {
            uocAfOrderItemMapper.insertBatch(UocRu.jsl(afOrderItemBoList, UocAfOrderItemPo.class));
        }

        List<UocOrderAccessory> orderAccessoryBoList = afOrderDo.getOrderAccessoryBoList();
        if (ObjectUtil.isNotEmpty(orderAccessoryBoList)) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(orderAccessoryBoList, UocOrderAccessoryPo.class));
        }
        UocOrdLogisticsRela takeAddress = afOrderDo.getTakeAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(takeAddress, UocOrdLogisticsRelaPo.class));
        }
        UocOrdLogisticsRela returnAddress = afOrderDo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(returnAddress, UocOrdLogisticsRelaPo.class));
        }
        return afOrderDo;
    }


    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        List<UocAfItemMapPo> list = uocAfItemMapMapper.getList(UocRu.js(uocAfItemMapQryBo, UocAfItemMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfItemMap.class) : new ArrayList<>();
    }

    @Override
    public void modifyBatchAfOrderRemark(List<UocAfOrderDo> uocAfOrderDoList) {
        if (!CollectionUtils.isEmpty(uocAfOrderDoList)) {
            uocAfOrderMapper.updateBatch(UocRu.jsl(uocAfOrderDoList, UocAfOrderPo.class), UocRu.js(uocAfOrderDoList.get(0), UocAfOrderPo.class));
            List<UocOrdLogisticsRela> uocOrdLogisticsRelas = new ArrayList<>();
            for (UocAfOrderDo uocAfOrderDo : uocAfOrderDoList) {
                if (null!=uocAfOrderDo.getReturnAddress()&&null!=uocAfOrderDo.getReturnAddress().getContactId()){
                   uocOrdLogisticsRelas.add(uocAfOrderDo.getReturnAddress());
                }
            }
            if (!CollectionUtils.isEmpty(uocOrdLogisticsRelas)) {
                uocOrdLogisticsRelaMapper.insertBatch(UocRu.jsl(uocOrdLogisticsRelas, UocOrdLogisticsRelaPo.class));
            }
        }
    }

    @Override
    public void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo) {
        uocAfOrderMapper.updateExtId(UocRu.js(afOrderDo, UocAfOrderPo.class));

    }

    @Override
    public void saveAfOrderWayBill(UocAfOrderWaybill uocAfOrderWaybill) {
        if (ObjectUtil.isNotEmpty(uocAfOrderWaybill)) {
            uocAfOrderWaybillMapper.insert(UocRu.js(uocAfOrderWaybill, UocAfOrderWaybillPo.class));
            UocAfOrderPo set = new UocAfOrderPo();
            set.setWaybillFlag(0);
            UocAfOrderPo where = new UocAfOrderPo();
            where.setAfOrderId(uocAfOrderWaybill.getAfOrderId());
            uocAfOrderMapper.updateBy(set, where);
        }
    }

    @Override
    public void modifyAfOrderState(UocAfOrderDo afOrderDo) {
        uocAfOrderMapper.updateStateId(UocRu.js(afOrderDo, UocAfOrderPo.class));
    }
    
    @Override
    public List<UocAfOrderDo> getCheckAfOrders(UocAfOrderDo afOrderDo) {
        List<UocAfOrderPo> uocAfOrderPos = uocAfOrderMapper.getCheckAfOrders(UocRu.js(afOrderDo, UocAfOrderPo.class));
        return UocRu.jsl(uocAfOrderPos,UocAfOrderDo.class);
    }

    /**
     * 查询售后单明细
     */
    @Override
    public UocAfOrderItem getAfOrderItem(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        //定义出参对象
        UocAfOrderItem uocAfOrderItem = new UocAfOrderItem();

        //调用根据条件查询单条数据
        UocAfOrderItemPo uocAfOrderItemPo = this.uocAfOrderItemMapper.getModelBy(UocRu.js(uocAfOrderItemQryBo, UocAfOrderItemPo.class));

        if (ObjectUtil.isNotEmpty(uocAfOrderItemPo)) {
            //出参转换
            uocAfOrderItem = UocRu.js(uocAfOrderItemPo, UocAfOrderItem.class);
        }

        return uocAfOrderItem;
    }

    /**
     * 新增临时验收售后处理任务
     */
    @Override
    public void addInspTempAfProcessTask(UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo) {
        //定义新增参数，转换入参
        UocInspTempAfProcessTaskPO addInspTempAfProcessTask = UocRu.js(uocInspTempAfProcessTaskDo, UocInspTempAfProcessTaskPO.class);
        //设置任务ID
        addInspTempAfProcessTask.setTaskId(IdUtil.nextId());
        //设置创建时间
        addInspTempAfProcessTask.setCreateTime(new Date());
        //调用插入单条数据
        this.uocInspTempAfProcessTaskMapper.insert(addInspTempAfProcessTask);
    }

    /**
     * 分页查询临时验收售后处理任务列表
     */
    @Override
    public UocInspTempAfProcessTaskQryRspPageBo getInspTempAfProcessTaskPageList(UocInspTempAfProcessTaskQryReqPageBo reqPageBo) {
        //定义出参对象
        UocInspTempAfProcessTaskQryRspPageBo rspPageBo = new UocInspTempAfProcessTaskQryRspPageBo();

        //设置分页参数
        Page<UocInspTempAfProcessTaskPO> page = new Page<>(reqPageBo.getPageNo(), reqPageBo.getPageSize());

        //入参条件参数转换
        UocInspTempAfProcessTaskPO queryUocInspTempAfProcessTaskPage = UocRu.js(reqPageBo, UocInspTempAfProcessTaskPO.class);

        //调用根据条件分页查询列表数据
        List<UocInspTempAfProcessTaskPO> uocInspTempAfProcessTaskMapperListPage = this.uocInspTempAfProcessTaskMapper.getListPage(queryUocInspTempAfProcessTaskPage, page);

        if (CollectionUtils.isEmpty(uocInspTempAfProcessTaskMapperListPage)) {
            rspPageBo.setPageNo(reqPageBo.getPageNo());
            rspPageBo.setRecordsTotal(0);
            rspPageBo.setTotal(0);
            rspPageBo.setRows(new ArrayList<>());
            return rspPageBo;
        }

        //出参转换
        List<UocInspTempAfProcessTaskQryPageBo> uocInspTempAfProcessTaskQryPageBoList = UocRu.jsl(uocInspTempAfProcessTaskMapperListPage, UocInspTempAfProcessTaskQryPageBo.class);

        //出参
        rspPageBo.setPageNo(reqPageBo.getPageNo());
        rspPageBo.setRecordsTotal(page.getTotalCount());
        rspPageBo.setTotal(page.getTotalPages());
        rspPageBo.setRows(uocInspTempAfProcessTaskQryPageBoList);
        return rspPageBo;
    }

    /**
     * 修改临时验收售后处理任务
     */
    @Override
    public void updateInspTempAfProcessTask(UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo) {
        //定义临时验收售后处理任务修改Set
        UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskSet = new UocInspTempAfProcessTaskPO();
        //设置状态
        uocInspTempAfProcessTaskSet.setStatus(uocInspTempAfProcessTaskDo.getStatus());
        //设置修改时间
        uocInspTempAfProcessTaskSet.setUpdateTime(new Date());

        //定义临时验收售后处理修改Where
        UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskWhere = new UocInspTempAfProcessTaskPO();
        //设置任务ID
        uocInspTempAfProcessTaskWhere.setTaskId(uocInspTempAfProcessTaskDo.getTaskId());

        //调用根据条件更新数据
        this.uocInspTempAfProcessTaskMapper.updateBy(uocInspTempAfProcessTaskSet, uocInspTempAfProcessTaskWhere);
    }
}
