package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 标题:UocOrderRelPo
 * 说明:订单外部关联表
 * 时间:2022-04-01 16:25
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderRelPo implements Serializable {
	private static final long serialVersionUID = -655607891371338029L;

	//ID")
	private Long id;

	//订单ID")
	private Long orderId;

	//关联对象id")
	private Long objId;

	//关联对象类型 1.订单 2.销售单 3.执行单 4.发货单 5.收货单 6.售后服务单 7.支付单 99.其他")
	private Integer objType;

	//关联ID")
	private String relId;

	//关联类型 0普通开票 1上游开票 2服务费")
	private Integer relType;

	//关联状态 0未提交 1已提交 2挂起 ")
	private Integer relStatus;

	//订单来源系统")
	private String orderSystem;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//关联类型 0普通开票 1上游开票 2服务费")
	private List<Integer> relTypeList;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;

}
