package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: UocAlertInfoPO
 * @Description: UocAlertInfoPO
 * @author: Luokan
 * @date: 2024年08月06日10:06:22
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class UocAlertInfoPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
    private Long id;
	/**
	 * 订单id
	 */
	private Long orderId;
	/**
	 * 单据ID
	 */
    private String objId;
    private List<Long> objIds;
	/**
	 * 类型：1销售单、2售后单
	 */
    private Integer objType;
	/**
	 * 预警类型：1超期未发货、2超期未收货、3超期未验收、4供应商超时未售后、5采购方超时未售后
	 */
    private Integer alertType;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 预警状态：0未处理，1已处理，2待处理(中间状态)
	 */
    private Integer alertState;
	/**
	 * 预警状态：0未处理，1已处理，2待处理(中间状态)
	 */
	private Integer oldAlertState;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 单据创建人
	 */
    private Long createUserId;
	/**
	 * 单据创建人名称
	 */
    private String createUserName;
	/**
	 * 单据创建人机构ID
	 */
    private Long createOrgId;
	/**
	 * 单据创建人机构名称
	 */
    private String createOrgName;
	/**
	 * 单据创建人公司ID
	 */
    private Long createCompanyId;
	/**
	 * 单据创建人公司名称
	 */
    private String createCompanyName;
	/**
	 * 单据创建人机构树
	 */
    private String createOrgPath;
	/**
	 * 是否发送：0 否 1是
	 */
    private Integer isSend;

}