package com.tydic.dyc.oc.repository.dao;

import com.tydic.dyc.oc.repository.po.UocAlertInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: UocAlertInfoMapper
 * @Description: UocAlertInfoMapper
 * @author: Luokan
 * @date: 2024年08月06日10:06:22
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface UocAlertInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<UocAlertInfoPO>
     * @author: Luokan
     * @date: 2024年08月06日10:06:22
     */
    List<UocAlertInfoPO> selectByCondition(UocAlertInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: Luokan
     * @date: 2024年08月06日10:06:22
     */
    int delete(UocAlertInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: Luokan
     * @date: 2024年08月06日10:06:22
     */
    int insert(UocAlertInfoPO record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: Luokan
     * @date: 2024年08月06日10:06:22
     */
    int update(UocAlertInfoPO record);
    int updateBatch1(UocAlertInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: Luokan
     * @date: 2024年08月06日10:06:22
     */
    void insertBatch(List<UocAlertInfoPO> list);

    /**
     * 批量修改
     * @param uocAlertInfoPO
     */
    void updateBatch(UocAlertInfoPO uocAlertInfoPO);

    void updateBatchByIsSend(UocAlertInfoPO uocAlertInfoPO);

    /**
     * 查询预警条数
     * @return
     */
    List<UocAlertInfoPO> qryActAlertInfoCountList();
}
