package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderItemPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：快照销售订单明细表
 **/
@Mapper
@Repository
public interface UocSnapSaleOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocSnapSaleOrderItemPO set, @Param("where") UocSnapSaleOrderItemPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @return UocSnapSaleOrderItemPO 结果对象
	 */
	UocSnapSaleOrderItemPO getModelBy(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @return List<UocSnapSaleOrderItemPO> 结果对象
	 */
	List<UocSnapSaleOrderItemPO> getList(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocSnapSaleOrderItemPO> 结果对象
	 */
	List<UocSnapSaleOrderItemPO> getListPage(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo, Page<UocSnapSaleOrderItemPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocSnapSaleOrderItemPO> list);

	/**
	 * 根据条件分页查询订单快照列表数据
	 *
	 * @param uocSnapSaleOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocSnapSaleOrderItemPO> 结果对象
	 */
	List<UocSnapSaleOrderItemPO> getSnapshotOrderListPage(UocSnapSaleOrderItemPO uocSnapSaleOrderItemPo, Page<UocSnapSaleOrderItemPO> page);

}
