package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.qrybo.*;
import com.tydic.dyc.oc.model.common.sub.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspAgreementInfoBo;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocCommonRepositoryImpl
 * 说明:通用
 * 时间:2022/2/25 19:38
 * 作者:罗有
 */

@Service
@Slf4j
public class UocCommonRepositoryImpl implements UocCommonRepository {
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;

    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;

    @Autowired
    private UocOrderBusiOperRecordMapper uocOrderBusiOperRecordMapper;

    @Autowired
    private UocConfTabOrdStateMapper uocConfTabOrdStateMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Autowired
    private UocConfSupplierMapper uocConfSupplierMapper;

    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @Autowired
    private UocOrderMsgPoolMapper uocOrderMsgPoolMapper;

    @Autowired
    private UocOrderQueryIndexMapper uocOrderQueryIndexMapper;

    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;

    @Autowired
    private CfcRedisSerialService cfcRedisSerialService;
    @Autowired
    private UocTodoMapper uocTodoMapper;

    @Autowired
    private CfcParamConfigMapper cfcParamConfigMapper;

    @Autowired
    private CfcParamConfigItemMapper cfcParamConfigItemMapper;

    @Autowired
    private UocSaleItemMapMapper uocSaleItemMapMapper;

    @Autowired
    private UocSaleOrderStateToStageConfigMapper uocSaleOrderStateToStageConfigMapper;

    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;

    @Autowired
    private UocSaleOrderMapMapper uocSaleOrderMapMapper;

    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;
    
    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;
    
    @Autowired
    private UocOrderAgreementMapper uocOrderAgreementMapper;

    @Autowired
    private UocAlertInfoMapper uocAlertInfoMapper;


    @Value("${obs.fileUrl:}")
    private String obsFileUrl;


    @Override
    public void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (!CollectionUtils.isEmpty(uocOrderAccessoryList)) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        }
    }

    @Override
    public void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
            updateSetPo.setFinishTime(new Date());
            updateSetPo.setDealOperId(uocOrderTaskInst.getDealOperId());
            updateSetPo.setDealOperName(uocOrderTaskInst.getDealOperName());
            updateSetPo.setDealResult(uocOrderTaskInst.getDealResult());
            updateSetPo.setDealRemark(uocOrderTaskInst.getDealRemark());
            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
            updateWherePo.setProcInstId(uocOrderTaskInst.getProcInstId());
            uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }

    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            uocOrderTaskInstMapper.insertBatch(UocRu.jsl(saveTaskList, UocOrderTaskInstPo.class));
        }
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        uocOrderProcInstMapper.insert(UocRu.js(inst, UocOrderProcInstPo.class));
        return inst;
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return UocRu.jsl(uocOrderProcInstMapper.getList(UocRu.js(inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        if (ObjectUtil.isNotEmpty(dealList)) {
            uocOrderTaskDealMapper.insertBatch(UocRu.jsl(dealList, UocOrderTaskDealPo.class));
        }
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (ObjectUtil.isNotEmpty(uocOrderStateChgLog)) {
            uocOrderStateChgLogMapper.insert(UocRu.js(uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        }
        return uocOrderStateChgLog;
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        if (ObjectUtil.isNotEmpty(taskInst)) {
            return UocRu.jsl(uocOrderTaskInstMapper.getList(UocRu.js(taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = UocRu.js(inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setProcInstId(inst.getProcInstId());
        uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    @Override
    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        List<UocOrderBusiOperRecordPo> recordPoList = UocRu.jsl(recordList, UocOrderBusiOperRecordPo.class);
        uocOrderBusiOperRecordMapper.insertBatch(recordPoList);
    }

    @Override
    public String getOrderNoSingle(String code) {
       /* CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter(UocObjNoConstants.UOC);
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType(UocObjNoConstants.ORG_TYPE);
        CfcEncodedSerialGetServiceRspBO encodedSerial = encodedSerialGetService.getEncodedSerial(getBo);
        if (CollectionUtils.isEmpty(encodedSerial.getSerialNoList()) || StringUtils.isBlank(encodedSerial.getSerialNoList().get(0))) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "获取单据编号为空");
        }
        return encodedSerial.getSerialNoList().get(0);*/

        //redis版编号获取
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter(UocObjNoConstants.UOC);
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType(UocObjNoConstants.ORG_TYPE);
        CfcEncodedSerialGetServiceRspBO encodedSerial = cfcRedisSerialService.getSerial(getBo);
        if (CollectionUtils.isEmpty(encodedSerial.getSerialNoList()) || StringUtils.isBlank(encodedSerial.getSerialNoList().get(0))) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "获取单据编号为空");
        }
        return encodedSerial.getSerialNoList().get(0);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst inst) {
        UocOrderTaskInstPo set = UocRu.js(inst, UocOrderTaskInstPo.class);
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(inst.getTaskInstId());
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setId(inst.getId());
        where.setProcState(inst.getProcState());
        uocOrderTaskInstMapper.updateBy(set, where);
    }

    @Autowired
    private FileClient fileClient;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    public static final String FILE_TYPE_OBS = "OBS";

    @Override
    public UocFile uploadFile(UocFile uocFile) {

        String path = fileClient.uploadFileByInputStream(uocFile.getPath()+"/"+UUID.randomUUID().toString().replace("-", ""), uocFile.getFilename(), uocFile.getInputStream());
        String fileUrl = path;
        /*if (FILE_TYPE_OSS.equals(uocFile.getFileType())) {
            fileUrl = path;
        } else if (FILE_TYPE_FASTDFS.equals(uocFile.getFileType())) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo(path);
            fileUrl = "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else if (FILE_TYPE_OBS.equals(uocFile.getFileType())) {
            if (path.startsWith("http")) {
                fileUrl = path;
            } else {
                fileUrl = obsFileUrl + path;
            }
        } else {
            throw new ZTBusinessException("暂不支持的文件服务器类型");
        }*/
        UocFile uocF = new UocFile();
        uocF.setUrl(fileUrl);
        return uocF;
    }

    @Override
    public int saveOrderQueryIndex(UocOrderQueryIndex index) {
        return uocOrderQueryIndexMapper.insert(JUtil.js(index, UocOrderQueryIndexPo.class));
    }

    @Override
    public void deleteTaskInstByStepIdAndFinshTag(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setProcState(taskInst.getProcState());
        uocOrderTaskInstMapper.deleteTaskInstByStepIdAndFinshTag(where);
    }

    @Override
    public void saveProcTaskInstLog(List<UocOrderTaskInst> saveTaskList) {
        List<UocOrderTaskInstLogPo> uocOrderTaskInstLogPos = UocRu.jsl(saveTaskList, UocOrderTaskInstLogPo.class);
        if (!CollectionUtils.isEmpty(uocOrderTaskInstLogPos)) {
            uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
        }
    }

    @Override
    public void deleteProcTaskInstByIds(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setIds(taskInst.getIds());
        uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
    }

    @Override
    public void deleteTaskInstByTaskId(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(taskInst.getTaskInstId());
        uocOrderTaskInstMapper.deleteTaskInstByTaskId(where);
    }

    @Override
    public UocQueryAlertStatisticsRspBO queryAlertStatistics(UocQueryAlertStatisticsReqBO reqBO) {
        UocQueryAlertStatisticsRspBO rspBO = new UocQueryAlertStatisticsRspBO();
        List<UocAlertInfoPO> uocAlertInfoPOS = uocAlertInfoMapper.qryActAlertInfoCountList();
        if (CollectionUtils.isEmpty(uocAlertInfoPOS)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }
        for (UocAlertInfoPO uocAlertInfoPO : uocAlertInfoPOS) {
            int objType = uocAlertInfoPO.getObjType();
            int alertType = uocAlertInfoPO.getAlertType();
            int alertCount = uocAlertInfoPO.getAlertCount();
            switch (objType) {
                case 2:
                    switch (alertType) {
                        case 1:
                            rspBO.setAgrOrderTimeoutUnshippedWarningCount(alertCount);
                            break;
                        case 2:
                            rspBO.setAgrOrderTimeoutUnreceivedWarningCount(alertCount);
                            break;
                        case 3:
                            rspBO.setAgrOrderTimeoutUnacceptedWarningCount(alertCount);
                            break;
                        case 4:
                            rspBO.setEcOrderTimeoutUnshippedWarningCount(alertCount);
                            break;
                        case 5:
                            rspBO.setEcOrderTimeoutUnreceivedWarningCount(alertCount);
                            break;
                        case 6:
                            rspBO.setEcOrderTimeoutUnacceptedWarningCount(alertCount);
                            break;
                    }
                    break;
                case 20:
                    switch (alertType) {
                        case 21:
                            rspBO.setEcAfterSalesTimeoutUnconfirmedWarningCount(alertCount);
                            break;
                        case 22:
                            rspBO.setEcAfterSalesTimeoutUnfinishedWarningCount(alertCount);
                            break;
                        case 23:
                            rspBO.setAgrAfterSalesTimeoutUnconfirmedWarningCount(alertCount);
                            break;
                        case 24:
                            rspBO.setAgrAfterSalesTimeoutUnfinishedWarningCount(alertCount);
                            break;
                    }
                    break;
            }
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public void updateTaskDeal(UocOrderTaskDeal taskDeal) {
        UocOrderTaskDealPo set = new UocOrderTaskDealPo();
        set.setDealId(taskDeal.getDealId());
        set.setDealName(taskDeal.getDealName());
        UocOrderTaskDealPo where = new UocOrderTaskDealPo();
        where.setTaskInstId(taskDeal.getTaskInstId());
        uocOrderTaskDealMapper.updateBy(set, where);
    }

    @Override
    public int saveTodoInfo(UocTodo uocTodo) {
        return uocTodoMapper.insert(UocRu.js(uocTodo, UocTodoPo.class));
    }

    @Override
    public int updateTodoById(UocTodo uocTodo) {
        return uocTodoMapper.updateById(UocRu.js(uocTodo, UocTodoPo.class));
    }

    @Override
    public UocTodo getTodoInfo(UocTodo uocTodo) {
        UocTodoPo modelBy = uocTodoMapper.getModelBy(UocRu.js(uocTodo, UocTodoPo.class));
        return ObjectUtil.isNotEmpty(modelBy) ? UocRu.js(modelBy, UocTodo.class) : new UocTodo();
    }

    @Override
    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        List<UocTodoPo> todoPoList = uocTodoMapper.getList(UocRu.js(uocTodo, UocTodoPo.class));
        return CollectionUtils.isEmpty(todoPoList) ? new ArrayList<>() : UocRu.jsl(todoPoList, UocTodo.class);
    }

    @Override
    public void insertBatchTodo(List<UocTodo> list) {
        List<UocTodoPo> recordPoList = UocRu.jsl(list, UocTodoPo.class);
        uocTodoMapper.insertBatch(recordPoList);
    }

    @Override
    public UocCfcParamConfigDo qryCfcParamByCode(String paramCode) {
        UocCfcParamConfigDo retDo = new UocCfcParamConfigDo();
        CfcParamConfigPo qryPo = new CfcParamConfigPo();
        qryPo.setParamConfigCode(paramCode);
        CfcParamConfigPo qryRspPo = cfcParamConfigMapper.getModelBy(qryPo);
        if (ObjectUtil.isNotEmpty(qryRspPo)) {
            BeanUtils.copyProperties(qryRspPo, retDo);
            CfcParamConfigItemPo qryItemPo = new CfcParamConfigItemPo();
            qryItemPo.setParamConfigCode(paramCode);
            List<CfcParamConfigItemPo> itemListPo = cfcParamConfigItemMapper.getList(qryItemPo);
            if (ObjectUtil.isNotEmpty(itemListPo)) {
                retDo.setItemList(JUtil.jsl(itemListPo, UocCfcParamConfigItemDo.class));
            }
        }
        return retDo;
    }

    @Override
    public UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo) {
        CfcParamConfigItemPo where = new CfcParamConfigItemPo();
        CfcParamConfigItemPo set = new CfcParamConfigItemPo();
        where.setItemId(reqDo.getItemId());
        set.setItemValue(reqDo.getItemValue());
        set.setCreateTime(reqDo.getCreateTime());
        set.setCreateId(reqDo.getCreateId());
        set.setCreateName(reqDo.getCreateName());
        cfcParamConfigItemMapper.updateBy(set, where);
        return reqDo;
    }

    @Override
    public UocQryMateriaOrderNoBo qryMateriaBySkuIdAndUserId(UocQryMateriaOrderNoBo qryBo) {
        return uocSaleItemMapMapper.qryMateriaBySkuIdAndUserId(qryBo);
    }

    @Override
    public UocQrySaleOrderStageBO qrySaleOrderStageByOrderStateAndprocState(UocQrySaleOrderStageBO qryBo) {
        return uocSaleOrderStateToStageConfigMapper.getOrderStageByOrderStateAndProcState(qryBo);
    }


    @Override
    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        UocConfSupplierPo uocConfSupplierPo = new UocConfSupplierPo();
        uocConfSupplierPo.setSupNo(goodsSupplierNo);
        uocConfSupplierPo = uocConfSupplierMapper.getModelBy(uocConfSupplierPo);
        return ObjectUtil.isNotEmpty(uocConfSupplierPo) ? UocRu.js(uocConfSupplierPo, UocConfSupplierBo.class) : new UocConfSupplierBo();
    }

    @Override
    public List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO) {
        UocConfSupplierPo qrySupConfPo = new UocConfSupplierPo();
        qrySupConfPo.setSupplierNos(uocConfSupplierDO.getSupplierNos());
        qrySupConfPo.setLimitStatus(uocConfSupplierDO.getLimitStatus());
        qrySupConfPo.setSupNo(uocConfSupplierDO.getSupNo());
        qrySupConfPo.setBusinessTypeCode(uocConfSupplierDO.getBusinessTypeCode());
        List<UocConfSupplierPo> confSupplierList = uocConfSupplierMapper.getList(qrySupConfPo);
        return ObjectUtil.isNotEmpty(confSupplierList) ? UocRu.jsl(confSupplierList, UocConfSupplierDO.class) : new ArrayList<>();
    }

    @Autowired
    private UocStateCalculatorConfMapper uocStateCalculatorConfMapper;

    @Override
    public UocQryStateCalculatorBo qryUocStateCalculatorServerConfig(String callServerClassName) {
        UocStateCalculatorConfPO qryPo = new UocStateCalculatorConfPO();
        UocQryStateCalculatorBo retBo = new UocQryStateCalculatorBo();
        qryPo.setCallService(callServerClassName);
        UocStateCalculatorConfPO modelBy = uocStateCalculatorConfMapper.getModelBy(qryPo);
        if (ObjectUtil.isNotEmpty(modelBy)) {
            retBo.setCalculatorService(modelBy.getCalculatorService());
            return retBo;
        } else {
            return retBo;
        }
    }

    @Override
    public UocQryOrderStateChngLogBo qryUocLastChngStateByObjId(UocQryOrderStateChngLogBo qryBo) {
        UocQryOrderStateChngLogBo retBo = new UocQryOrderStateChngLogBo();
        UocOrderStateChgLogPo qryPo = new UocOrderStateChgLogPo();
        qryPo.setObjId(qryBo.getObjId());
        qryPo.setOrderId(qryBo.getOrderId());
        qryPo.setObjType(qryBo.getObjType());
        UocOrderStateChgLogPo lastModelBy = uocOrderStateChgLogMapper.getLastModelBy(qryPo);
        if (ObjectUtil.isNotEmpty(lastModelBy)) {
            retBo.setNewState(lastModelBy.getNewState());
            return retBo;
        } else {
            return retBo;
        }

    }

    @Autowired
    private SystemBusiLogMapper systemBusiLogMapper;

    @Override
    public UocOutLogSaveDo saveOutLog(UocOutLogSaveDo reqDo) {
        SystemBusiLogPO savePo = new SystemBusiLogPO();
        BeanUtils.copyProperties(reqDo, savePo);
        systemBusiLogMapper.insert(savePo);
        return reqDo;
    }

    @Override
    public UocQryInspItemsServiceRspBo qryInspItems(UocQryInspItemsServiceReqBo reqBo) {
        //1、校验入参
        validateArg(reqBo);
        UocQryInspItemsServiceRspBo rspBo = UocRu.success(UocQryInspItemsServiceRspBo.class);
        //2、查询验收单明细
        UocInspOrderItemPo qryInspItemPo = new UocInspOrderItemPo();

        qryInspItemPo.setInspOrderItemIdList(reqBo.getInspItemIdList());
        List<UocInspOrderItemPo> inspItemList = uocInspOrderItemMapper.getItemList(qryInspItemPo);
        List<Long> saleOrderIdList = inspItemList.stream().map(UocInspOrderItemPo::getSaleOrderId).distinct().collect(Collectors.toList());
        List<Long> saleOrderItemIdList = inspItemList.stream().map(UocInspOrderItemPo::getSaleOrderItemId).distinct().collect(Collectors.toList());

        //3、查询销售单扩展
        UocSaleOrderMapPo qrySaleMapPo = new UocSaleOrderMapPo();
        qrySaleMapPo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderMapPo> saleOrderMapPoList = uocSaleOrderMapMapper.getList(qrySaleMapPo);
        //按销售单id分类
        Map<Long, List<UocSaleOrderMapPo>> saleOrderExtMap = saleOrderMapPoList.stream().collect(Collectors.groupingBy(UocSaleOrderMapPo::getSaleOrderId));


        //4、查询销售单明细（算验收金额[验收数量 * sku单价]，供应商id）
        UocSaleOrderItemPo qrySaleItemPo = new UocSaleOrderItemPo();
        qrySaleItemPo.setSaleOrderItemIdList(saleOrderItemIdList);
        List<UocSaleOrderItemPo> saleOrderItemPoList = uocSaleOrderItemMapper.getList(qrySaleItemPo);
        //转map：销售单明细id为key，销售单明细对象为value
        Map<Long, UocSaleOrderItemPo> saleOrderItemMap = saleOrderItemPoList.stream().collect(Collectors.toMap(UocSaleOrderItemPo::getSaleOrderItemId, item -> item));

        //5、查询销售单明细扩展
        UocSaleItemMapPo qrySaleItemMapPo = new UocSaleItemMapPo();
        qrySaleItemMapPo.setSaleOrderItemIdList(saleOrderItemIdList);
        List<UocSaleItemMapPo> saleOrderItemMapPoList = uocSaleItemMapMapper.getList(qrySaleItemMapPo);
        //按销售单明细id分类
        Map<Long, List<UocSaleItemMapPo>> saleOrderItemExtMap = saleOrderItemMapPoList.stream().collect(Collectors.groupingBy(UocSaleItemMapPo::getSaleOrderItemId));
        
        
        // 查询销售单
        UocSaleOrderPo uocSaleOrderPo = new UocSaleOrderPo();
        uocSaleOrderPo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderPo> querySaleOrderResultPo = uocSaleOrderMapper.getList(uocSaleOrderPo);
        //转map：销售单d为key，销售单对象为value
        Map<Long, UocSaleOrderPo> saleOrderMap = querySaleOrderResultPo.stream().collect(Collectors.toMap(UocSaleOrderPo::getSaleOrderId, item -> item));
        //查询订单协议表
        Map<Long ,UocOrderAgreementPo> agreementPoMap = new HashMap<>();
        for (UocSaleOrderPo saleOrderPo: querySaleOrderResultPo){
            if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderPo.getOrderSource())){
                UocOrderAgreementPo uocOrderAgreementPo = new UocOrderAgreementPo();
                uocOrderAgreementPo.setId(saleOrderPo.getAgrDataId());
                uocOrderAgreementPo.setOrderId(saleOrderPo.getOrderId());
                UocOrderAgreementPo uocOrderAgreementResultPo = uocOrderAgreementMapper.getModelBy(uocOrderAgreementPo);
                if(ObjectUtil.isNotEmpty(uocOrderAgreementResultPo)){
                    agreementPoMap.put(saleOrderPo.getSaleOrderId(),uocOrderAgreementResultPo);
                }
            }
        }
    
        //6、组装出参数据
        for (UocInspOrderItemPo uocInspOrderItemPo : inspItemList) {
            Long inspOrderItemId = uocInspOrderItemPo.getInspOrderItemId();
            Long saleOrderId = uocInspOrderItemPo.getSaleOrderId();
            Long saleOrderItemId = uocInspOrderItemPo.getSaleOrderItemId();

            UocQryInspItemsServiceInspRspBo rspInspItemBo = new UocQryInspItemsServiceInspRspBo();
            rspBo.getInspItemList().add(rspInspItemBo);

            //验收单明细id
            rspInspItemBo.setInspOrderItemId(inspOrderItemId);

            //供应商id
            if (ObjectUtil.isNotEmpty(saleOrderItemMap.get(saleOrderItemId))) {
                rspInspItemBo.setSupplierId(saleOrderItemMap.get(saleOrderItemId).getSupplierId());
            }

            //组装验收金额
            if (ObjectUtil.isNotEmpty(saleOrderItemMap.get(saleOrderItemId))
                    && ObjectUtil.isNotEmpty(saleOrderItemMap.get(saleOrderItemId).getSalePrice())
                    && ObjectUtil.isNotEmpty(uocInspOrderItemPo.getInspItemCount())) {
                rspInspItemBo.setInspFee(uocInspOrderItemPo.getInspItemCount().multiply(saleOrderItemMap.get(saleOrderItemId).getSalePrice()));
            }

            //组装销售单明细，及其扩展数据
            UocQryInspItemsServiceSaleOrderItemRspBo rspSaleOrderItemBo = new UocQryInspItemsServiceSaleOrderItemRspBo();
            rspInspItemBo.setSaleOrderItemRspBo(rspSaleOrderItemBo);
            rspSaleOrderItemBo.setSaleOrderItemId(saleOrderItemId);
            rspSaleOrderItemBo.setExtFields(new ArrayList<>());

            if (ObjectUtil.isNotEmpty(saleOrderItemMap.get(saleOrderItemId))) {
                UocSaleOrderItemPo uocSaleOrderItemPo = saleOrderItemMap.get(saleOrderItemId);
                log.debug("验收明细查询，设置税率：saleOrderItemId:{},tax：{}", saleOrderItemId, uocSaleOrderItemPo.getTax());
                rspSaleOrderItemBo.setTax(uocSaleOrderItemPo.getTax());
            }

            List<UocSaleItemMapPo> uocSaleItemMapPos = saleOrderItemExtMap.get(saleOrderItemId);
            if(ObjectUtil.isNotEmpty(uocSaleItemMapPos)){
                for (UocSaleItemMapPo uocSaleItemMapPo : uocSaleItemMapPos) {
                    BaseExtendFieldBo rspSaleItemMapTmpBo = new BaseExtendFieldBo();
                    rspSaleOrderItemBo.getExtFields().add(rspSaleItemMapTmpBo);
                    rspSaleItemMapTmpBo.setFieldCode(uocSaleItemMapPo.getFieldCode());
                    rspSaleItemMapTmpBo.setFieldValue(uocSaleItemMapPo.getFieldValue());
                }
            }

            //组装销售单，及其扩展
            UocQryInspItemsServiceSaleOrderRspBo rspSaleOrderBo = new UocQryInspItemsServiceSaleOrderRspBo();
            rspInspItemBo.setSaleOrderRspBo(rspSaleOrderBo);
            rspSaleOrderBo.setSaleOrderId(saleOrderId);
            rspSaleOrderBo.setAgreementInfo(UocRu.js(agreementPoMap.get(saleOrderId), UocGetSaleOrderDetailServiceRspAgreementInfoBo.class));
            rspSaleOrderBo.setRemark(saleOrderMap.get(saleOrderId).getRemark());
            rspSaleOrderBo.setExtFields(new ArrayList<>());
            List<UocSaleOrderMapPo> tmpSaleOrderMapPoList = saleOrderExtMap.get(saleOrderId);
            if(ObjectUtil.isNotEmpty(tmpSaleOrderMapPoList)){
                for (UocSaleOrderMapPo uocSaleOrderMapPo : tmpSaleOrderMapPoList) {
                    BaseExtendFieldBo rspSaleMapTmpBo = new BaseExtendFieldBo();
                    rspSaleOrderBo.getExtFields().add(rspSaleMapTmpBo);
                    rspSaleMapTmpBo.setFieldCode(uocSaleOrderMapPo.getFieldCode());
                    rspSaleMapTmpBo.setFieldValue(uocSaleOrderMapPo.getFieldValue());
                }
            }


        }

        return rspBo;
    }

    //最大查询数量
    @Value("${uoc.qryInspItems.qryMaxCount:1000}")
    private int qryInspItemsQryMaxCount;

    private void validateArg(UocQryInspItemsServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getInspItemIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参属性[inspItemList]不能为空");
        }
        if (reqBo.getInspItemIdList().size() > qryInspItemsQryMaxCount) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "单次最大查询数量不能超过：" + qryInspItemsQryMaxCount);
        }


    }
}
